/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import org.apache.druid.msq.indexing.error.BaseMSQFault;

@JsonTypeName(value="TooManyAttemptsForJob")
public class TooManyAttemptsForJob
extends BaseMSQFault {
    static final String CODE = "TooManyAttemptsForJob";
    private final int maxRelaunchCount;
    private final String taskId;
    private final int currentRelaunchCount;
    private final String rootErrorMessage;

    @JsonCreator
    public TooManyAttemptsForJob(@JsonProperty(value="maxRelaunchCount") int maxRelaunchCount, @JsonProperty(value="currentRelaunchCount") int currentRelaunchCount, @JsonProperty(value="taskId") String taskId, @JsonProperty(value="rootErrorMessage") String rootErrorMessage) {
        super(CODE, "Total relaunch count across all workers %d exceeded max relaunch limit %d . Latest task[%s] failure reason: %s", currentRelaunchCount, maxRelaunchCount, taskId, rootErrorMessage);
        this.maxRelaunchCount = maxRelaunchCount;
        this.currentRelaunchCount = currentRelaunchCount;
        this.taskId = taskId;
        this.rootErrorMessage = rootErrorMessage;
    }

    @JsonProperty
    public int getMaxRelaunchCount() {
        return this.maxRelaunchCount;
    }

    @JsonProperty
    public String getTaskId() {
        return this.taskId;
    }

    @JsonProperty
    public int getCurrentRelaunchCount() {
        return this.currentRelaunchCount;
    }

    @JsonProperty
    public String getRootErrorMessage() {
        return this.rootErrorMessage;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TooManyAttemptsForJob that = (TooManyAttemptsForJob)o;
        return this.maxRelaunchCount == that.maxRelaunchCount && this.currentRelaunchCount == that.currentRelaunchCount && Objects.equals(this.taskId, that.taskId) && Objects.equals(this.rootErrorMessage, that.rootErrorMessage);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.maxRelaunchCount, this.taskId, this.currentRelaunchCount, this.rootErrorMessage);
    }
}

