/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import org.apache.druid.msq.indexing.error.BaseMSQFault;

@JsonTypeName(value="TooManyAttemptsForWorker")
public class TooManyAttemptsForWorker
extends BaseMSQFault {
    static final String CODE = "TooManyAttemptsForWorker";
    private final int maxPerWorkerRelaunchCount;
    private final String taskId;
    private final int workerNumber;
    private final String rootErrorMessage;

    @JsonCreator
    public TooManyAttemptsForWorker(@JsonProperty(value="maxPerWorkerRelaunchCount") int maxPerWorkerRelaunchCount, @JsonProperty(value="taskId") String taskId, @JsonProperty(value="workerNumber") int workerNumber, @JsonProperty(value="rootErrorMessage") String rootErrorMessage) {
        super(CODE, "Worker[%d] exceeded max relaunch count of %d for task[%s]. Latest failure reason: %s.", workerNumber, maxPerWorkerRelaunchCount, taskId, rootErrorMessage);
        this.maxPerWorkerRelaunchCount = maxPerWorkerRelaunchCount;
        this.taskId = taskId;
        this.workerNumber = workerNumber;
        this.rootErrorMessage = rootErrorMessage;
    }

    @JsonProperty
    public int getMaxPerWorkerRelaunchCount() {
        return this.maxPerWorkerRelaunchCount;
    }

    @JsonProperty
    public int getWorkerNumber() {
        return this.workerNumber;
    }

    @JsonProperty
    public String getTaskId() {
        return this.taskId;
    }

    @JsonProperty
    public String getRootErrorMessage() {
        return this.rootErrorMessage;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TooManyAttemptsForWorker that = (TooManyAttemptsForWorker)o;
        return this.maxPerWorkerRelaunchCount == that.maxPerWorkerRelaunchCount && this.workerNumber == that.workerNumber && Objects.equals(this.taskId, that.taskId) && Objects.equals(this.rootErrorMessage, that.rootErrorMessage);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.maxPerWorkerRelaunchCount, this.taskId, this.workerNumber, this.rootErrorMessage);
    }
}

