/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.report;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.msq.exec.OutputChannelMode;
import org.apache.druid.msq.kernel.QueryDefinition;
import org.apache.druid.msq.kernel.ShuffleKind;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.kernel.controller.ControllerStagePhase;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class MSQStagesReport {
    private final List<Stage> stages;

    @JsonCreator
    public MSQStagesReport(List<Stage> stages) {
        this.stages = (List)Preconditions.checkNotNull(stages, (Object)"stages");
    }

    public static MSQStagesReport create(QueryDefinition queryDef, Map<Integer, ControllerStagePhase> stagePhaseMap, Map<Integer, Interval> stageRuntimeMap, Map<Integer, Integer> stageWorkerCountMap, Map<Integer, Integer> stagePartitionCountMap, Map<Integer, OutputChannelMode> stageOutputChannelModeMap) {
        ArrayList<Stage> stages = new ArrayList<Stage>();
        int[] stageNumbers = queryDef.getStageDefinitions().stream().mapToInt(StageDefinition::getStageNumber).toArray();
        Arrays.sort(stageNumbers);
        for (int stageNumber : stageNumbers) {
            StageDefinition stageDef = queryDef.getStageDefinition(stageNumber);
            int workerCount = stageWorkerCountMap.getOrDefault(stageNumber, 0);
            int partitionCount = stagePartitionCountMap.getOrDefault(stageNumber, 0);
            Interval stageRuntimeInterval = stageRuntimeMap.get(stageNumber);
            DateTime stageStartTime = stageRuntimeInterval == null ? null : stageRuntimeInterval.getStart();
            long stageDuration = stageRuntimeInterval == null ? 0L : stageRuntimeInterval.toDurationMillis();
            Stage stage = new Stage(stageNumber, stageDef, stagePhaseMap.get(stageNumber), workerCount, partitionCount, stageDef.doesShuffle() ? stageDef.getShuffleSpec().kind() : null, stageOutputChannelModeMap.get(stageNumber), stageStartTime, stageDuration);
            stages.add(stage);
        }
        return new MSQStagesReport(stages);
    }

    @JsonValue
    public List<Stage> getStages() {
        return this.stages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MSQStagesReport that = (MSQStagesReport)o;
        return Objects.equals(this.stages, that.stages);
    }

    public int hashCode() {
        return Objects.hash(this.stages);
    }

    public String toString() {
        return "MSQStagesReport{stages=" + String.valueOf(this.stages) + "}";
    }

    public static class Stage {
        private final int stageNumber;
        private final StageDefinition stageDef;
        @Nullable
        private final ControllerStagePhase phase;
        private final int workerCount;
        private final int partitionCount;
        private final ShuffleKind shuffleKind;
        private final OutputChannelMode outputChannelMode;
        private final DateTime startTime;
        private final long duration;

        @JsonCreator
        private Stage(@JsonProperty(value="stageNumber") int stageNumber, @JsonProperty(value="definition") StageDefinition stageDef, @JsonProperty(value="phase") @Nullable ControllerStagePhase phase, @JsonProperty(value="workerCount") int workerCount, @JsonProperty(value="partitionCount") int partitionCount, @JsonProperty(value="shuffle") ShuffleKind shuffleKind, @JsonProperty(value="output") OutputChannelMode outputChannelMode, @JsonProperty(value="startTime") @Nullable DateTime startTime, @JsonProperty(value="duration") long duration) {
            this.stageNumber = stageNumber;
            this.stageDef = stageDef;
            this.phase = phase;
            this.workerCount = workerCount;
            this.partitionCount = partitionCount;
            this.shuffleKind = shuffleKind;
            this.outputChannelMode = outputChannelMode;
            this.startTime = startTime;
            this.duration = duration;
        }

        @JsonProperty
        public int getStageNumber() {
            return this.stageNumber;
        }

        @JsonProperty(value="definition")
        public StageDefinition getStageDefinition() {
            return this.stageDef;
        }

        @Nullable
        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public ControllerStagePhase getPhase() {
            return this.phase;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        public int getWorkerCount() {
            return this.workerCount;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        public int getPartitionCount() {
            return this.partitionCount;
        }

        @JsonProperty(value="shuffle")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public ShuffleKind getShuffleKind() {
            return this.shuffleKind;
        }

        @JsonProperty(value="output")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public OutputChannelMode getOutputChannelMode() {
            return this.outputChannelMode;
        }

        @JsonProperty(value="sort")
        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        public boolean isSorting() {
            return this.stageDef.doesSortDuringShuffle();
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public DateTime getStartTime() {
            return this.startTime;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        public long getDuration() {
            return this.duration;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Stage stage = (Stage)o;
            return this.stageNumber == stage.stageNumber && this.workerCount == stage.workerCount && this.partitionCount == stage.partitionCount && this.duration == stage.duration && Objects.equals(this.stageDef, stage.stageDef) && this.phase == stage.phase && Objects.equals(this.startTime, stage.startTime);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.stageNumber, this.stageDef, this.phase, this.workerCount, this.partitionCount, this.startTime, this.duration});
        }

        public String toString() {
            return "Stage{stageNumber=" + this.stageNumber + ", stageDef=" + String.valueOf(this.stageDef) + ", phase=" + String.valueOf((Object)this.phase) + ", workerCount=" + this.workerCount + ", partitionCount=" + this.partitionCount + ", startTime=" + String.valueOf(this.startTime) + ", duration=" + this.duration + "}";
        }
    }
}

