/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.counters.CounterTracker;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSliceReader;
import org.apache.druid.msq.input.ReadableInputs;

public class MapInputSliceReader
implements InputSliceReader {
    private final Map<Class<? extends InputSlice>, InputSliceReader> readerMap;

    @Inject
    public MapInputSliceReader(Map<Class<? extends InputSlice>, InputSliceReader> readerMap) {
        this.readerMap = ImmutableMap.copyOf(readerMap);
    }

    @Override
    public int numReadableInputs(InputSlice slice) {
        return this.getReader(slice.getClass()).numReadableInputs(slice);
    }

    @Override
    public ReadableInputs attach(int inputNumber, InputSlice slice, CounterTracker counters, Consumer<Throwable> warningPublisher) {
        return this.getReader(slice.getClass()).attach(inputNumber, slice, counters, warningPublisher);
    }

    private InputSliceReader getReader(Class<? extends InputSlice> clazz) {
        InputSliceReader reader = this.readerMap.get(clazz);
        if (reader == null) {
            throw new ISE("Cannot handle inputSpec of class [%s]", new Object[]{clazz.getName()});
        }
        return reader;
    }
}

