/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.kernel;

import java.util.Comparator;
import java.util.Objects;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.msq.kernel.StageId;

public class StagePartition
implements Comparable<StagePartition> {
    private static final Comparator<StagePartition> COMPARATOR = Comparator.comparing(StagePartition::getStageId).thenComparing(StagePartition::getPartitionNumber);
    private final StageId stageId;
    private final int partitionNumber;

    public StagePartition(StageId stageId, int partitionNumber) {
        this.stageId = stageId;
        this.partitionNumber = partitionNumber;
    }

    public StageId getStageId() {
        return this.stageId;
    }

    public int getPartitionNumber() {
        return this.partitionNumber;
    }

    @Override
    public int compareTo(StagePartition that) {
        return COMPARATOR.compare(this, that);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StagePartition that = (StagePartition)o;
        return this.partitionNumber == that.partitionNumber && Objects.equals(this.stageId, that.stageId);
    }

    public int hashCode() {
        return Objects.hash(this.stageId, this.partitionNumber);
    }

    public String toString() {
        return StringUtils.format((String)"%s_%s", (Object[])new Object[]{this.stageId, this.partitionNumber});
    }
}

