/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.kernel.worker;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.frame.key.ClusterByPartitions;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.indexing.error.MSQFaultUtils;
import org.apache.druid.msq.kernel.ShuffleKind;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.kernel.StageId;
import org.apache.druid.msq.kernel.WorkOrder;
import org.apache.druid.msq.kernel.worker.WorkerStagePhase;
import org.apache.druid.msq.statistics.ClusterByStatisticsSnapshot;

public class WorkerStageKernel {
    private static final Logger log = new Logger(WorkerStageKernel.class);
    private final WorkOrder workOrder;
    private WorkerStagePhase phase = WorkerStagePhase.NEW;
    @Nullable
    private ClusterByStatisticsSnapshot resultKeyStatisticsSnapshot;
    private boolean doneReadingInput;
    @Nullable
    private ClusterByPartitions resultPartitionBoundaries;
    @Nullable
    private Object resultObject;
    @Nullable
    private Throwable exceptionFromFail;
    private final Set<Pair<StageId, Integer>> postedResultsComplete = new HashSet<Pair<StageId, Integer>>();

    private WorkerStageKernel(WorkOrder workOrder) {
        this.workOrder = workOrder;
        StageDefinition stageDef = workOrder.getStageDefinition();
        if (stageDef.doesShuffle() && stageDef.getShuffleSpec().kind() == ShuffleKind.GLOBAL_SORT && !stageDef.mustGatherResultKeyStatistics()) {
            this.resultPartitionBoundaries = (ClusterByPartitions)stageDef.generatePartitionBoundariesForShuffle(null, Integer.MAX_VALUE).valueOrThrow();
        }
    }

    public static WorkerStageKernel create(WorkOrder workOrder) {
        return new WorkerStageKernel(workOrder);
    }

    public WorkerStagePhase getPhase() {
        return this.phase;
    }

    public WorkOrder getWorkOrder() {
        return this.workOrder;
    }

    public StageDefinition getStageDefinition() {
        return this.workOrder.getStageDefinition();
    }

    public void startReading() {
        this.transitionTo(WorkerStagePhase.READING_INPUT);
    }

    public void startPreshuffleWaitingForResultPartitionBoundaries() {
        this.assertPreshuffleStatisticsNeeded(true);
        this.transitionTo(WorkerStagePhase.PRESHUFFLE_WAITING_FOR_RESULT_PARTITION_BOUNDARIES);
    }

    public void startPreshuffleWritingOutput() {
        this.transitionTo(WorkerStagePhase.PRESHUFFLE_WRITING_OUTPUT);
    }

    public void setResultKeyStatisticsSnapshot(@Nullable ClusterByStatisticsSnapshot resultKeyStatisticsSnapshot) {
        this.assertPreshuffleStatisticsNeeded(resultKeyStatisticsSnapshot != null);
        this.resultKeyStatisticsSnapshot = resultKeyStatisticsSnapshot;
        this.doneReadingInput = true;
    }

    public void setResultPartitionBoundaries(ClusterByPartitions resultPartitionBoundaries) {
        this.assertPreshuffleStatisticsNeeded(true);
        this.resultPartitionBoundaries = resultPartitionBoundaries;
    }

    public boolean hasResultKeyStatisticsSnapshot() {
        return this.resultKeyStatisticsSnapshot != null;
    }

    public boolean isDoneReadingInput() {
        return this.doneReadingInput;
    }

    public boolean hasResultPartitionBoundaries() {
        return this.resultPartitionBoundaries != null;
    }

    public ClusterByStatisticsSnapshot getResultKeyStatisticsSnapshot() {
        return (ClusterByStatisticsSnapshot)Preconditions.checkNotNull((Object)this.resultKeyStatisticsSnapshot, (Object)"resultKeyStatisticsSnapshot");
    }

    public ClusterByPartitions getResultPartitionBoundaries() {
        return (ClusterByPartitions)Preconditions.checkNotNull((Object)this.resultPartitionBoundaries, (Object)"resultPartitionBoundaries");
    }

    @Nullable
    public Object getResultObject() {
        if (this.phase == WorkerStagePhase.RESULTS_COMPLETE) {
            return this.resultObject;
        }
        throw new ISE("Results are not ready in phase[%s]", new Object[]{this.phase});
    }

    public Throwable getException() {
        if (this.phase == WorkerStagePhase.FAILED) {
            return this.exceptionFromFail;
        }
        throw new ISE("Stage has not failed", new Object[0]);
    }

    public void setResultsComplete(Object resultObject) {
        if (resultObject == null) {
            throw new NullPointerException("resultObject must not be null");
        }
        if (this.phase.isTerminal()) {
            return;
        }
        this.transitionTo(WorkerStagePhase.RESULTS_COMPLETE);
        this.resultObject = resultObject;
    }

    public void setStageFinished() {
        this.transitionTo(WorkerStagePhase.FINISHED);
    }

    public void fail(Throwable t) {
        Preconditions.checkNotNull((Object)t, (Object)"t");
        if (WorkerStagePhase.FAILED.canTransitionFrom(this.phase)) {
            this.transitionTo(WorkerStagePhase.FAILED);
            this.resultKeyStatisticsSnapshot = null;
            this.resultPartitionBoundaries = null;
            if (this.exceptionFromFail == null) {
                this.exceptionFromFail = t;
            }
        } else if (!MSQFaultUtils.isCanceledException(t)) {
            log.warn(t, "Stage[%s] failed while in phase[%s]", new Object[]{this.getStageDefinition().getId(), this.phase});
        }
    }

    public boolean addPostedResultsComplete(StageId stageId, int workerNumber) {
        return this.postedResultsComplete.add((Pair<StageId, Integer>)Pair.of((Object)stageId, (Object)workerNumber));
    }

    private void assertPreshuffleStatisticsNeeded(boolean delivered) {
        if (delivered != this.workOrder.getStageDefinition().mustGatherResultKeyStatistics()) {
            throw new ISE("Result key statistics %s, but %s, for stage[%s]", new Object[]{delivered ? "delivered" : "not delivered", this.workOrder.getStageDefinition().mustGatherResultKeyStatistics() ? "expected" : "not expected", this.workOrder.getStageDefinition().getId()});
        }
    }

    private void transitionTo(WorkerStagePhase newPhase) {
        if (!newPhase.canTransitionFrom(this.phase)) {
            throw new IAE("Cannot transition stage[%s] from[%s] to[%s]", new Object[]{this.workOrder.getStageDefinition().getId(), this.phase, newPhase});
        }
        log.info("Stage [%d] transitioning from old phase [%s] to new phase [%s]", new Object[]{this.workOrder.getStageNumber(), this.phase, newPhase});
        this.phase = newPhase;
    }
}

