/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit.scan;

import javax.annotation.Nullable;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.RowIdSupplier;
import org.apache.druid.segment.SimpleSettableOffset;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.data.IndexedInts;

public class ExternalColumnSelectorFactory
implements ColumnSelectorFactory {
    private static final String ERROR_MESSAGE_FORMAT_STRING = "Error while trying to read the external data source at inputSource [%s], rowNumber [%d], columnName [%s]";
    private final ColumnSelectorFactory delegate;
    private final InputSource inputSource;
    private final RowSignature rowSignature;
    private final SimpleSettableOffset offset;

    public ExternalColumnSelectorFactory(ColumnSelectorFactory delgate, InputSource inputSource, RowSignature rowSignature, SimpleSettableOffset offset) {
        this.delegate = delgate;
        this.inputSource = inputSource;
        this.rowSignature = rowSignature;
        this.offset = offset;
    }

    public DimensionSelector makeDimensionSelector(final DimensionSpec dimensionSpec) {
        return new DimensionSelector(){
            final DimensionSelector delegateDimensionSelector;
            final ExpressionType expressionType;
            {
                this.delegateDimensionSelector = ExternalColumnSelectorFactory.this.delegate.makeDimensionSelector(dimensionSpec);
                this.expressionType = ExpressionType.fromColumnType((TypeSignature)dimensionSpec.getOutputType());
            }

            public IndexedInts getRow() {
                return this.delegateDimensionSelector.getRow();
            }

            public ValueMatcher makeValueMatcher(@Nullable String value) {
                return this.delegateDimensionSelector.makeValueMatcher(value);
            }

            public ValueMatcher makeValueMatcher(DruidPredicateFactory predicateFactory) {
                return this.delegateDimensionSelector.makeValueMatcher(predicateFactory);
            }

            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                this.delegateDimensionSelector.inspectRuntimeShape(inspector);
            }

            @Nullable
            public Object getObject() {
                try {
                    if (this.expressionType == null) {
                        return this.delegateDimensionSelector.getObject();
                    }
                    return ExprEval.bestEffortOf((Object)this.delegateDimensionSelector.getObject()).castTo(this.expressionType).value();
                }
                catch (Exception e) {
                    throw ExternalColumnSelectorFactory.createException(e, dimensionSpec.getDimension(), ExternalColumnSelectorFactory.this.inputSource, ExternalColumnSelectorFactory.this.offset);
                }
            }

            public Class<?> classOfObject() {
                return this.delegateDimensionSelector.classOfObject();
            }

            public int getValueCardinality() {
                return this.delegateDimensionSelector.getValueCardinality();
            }

            @Nullable
            public String lookupName(int id) {
                return this.delegateDimensionSelector.lookupName(id);
            }

            public boolean nameLookupPossibleInAdvance() {
                return this.delegateDimensionSelector.nameLookupPossibleInAdvance();
            }

            @Nullable
            public IdLookup idLookup() {
                return this.delegateDimensionSelector.idLookup();
            }
        };
    }

    public ColumnValueSelector makeColumnValueSelector(final String columnName) {
        return new ColumnValueSelector(){
            final ColumnValueSelector delegateColumnValueSelector;
            final ExpressionType expressionType;
            {
                this.delegateColumnValueSelector = ExternalColumnSelectorFactory.this.delegate.makeColumnValueSelector(columnName);
                this.expressionType = ExpressionType.fromColumnType((TypeSignature)ExternalColumnSelectorFactory.this.rowSignature.getColumnType(columnName).orElse(null));
            }

            public double getDouble() {
                try {
                    return this.delegateColumnValueSelector.getDouble();
                }
                catch (Exception e) {
                    throw ExternalColumnSelectorFactory.createException(e, columnName, ExternalColumnSelectorFactory.this.inputSource, ExternalColumnSelectorFactory.this.offset);
                }
            }

            public float getFloat() {
                try {
                    return this.delegateColumnValueSelector.getFloat();
                }
                catch (Exception e) {
                    throw ExternalColumnSelectorFactory.createException(e, columnName, ExternalColumnSelectorFactory.this.inputSource, ExternalColumnSelectorFactory.this.offset);
                }
            }

            public long getLong() {
                try {
                    return this.delegateColumnValueSelector.getLong();
                }
                catch (Exception e) {
                    throw ExternalColumnSelectorFactory.createException(e, columnName, ExternalColumnSelectorFactory.this.inputSource, ExternalColumnSelectorFactory.this.offset);
                }
            }

            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                this.delegateColumnValueSelector.inspectRuntimeShape(inspector);
            }

            public boolean isNull() {
                return this.delegateColumnValueSelector.isNull();
            }

            @Nullable
            public Object getObject() {
                try {
                    if (this.expressionType == null) {
                        return this.delegateColumnValueSelector.getObject();
                    }
                    return ExprEval.bestEffortOf((Object)this.delegateColumnValueSelector.getObject()).castTo(this.expressionType).value();
                }
                catch (Exception e) {
                    throw ExternalColumnSelectorFactory.createException(e, columnName, ExternalColumnSelectorFactory.this.inputSource, ExternalColumnSelectorFactory.this.offset);
                }
            }

            public Class classOfObject() {
                return this.delegateColumnValueSelector.classOfObject();
            }
        };
    }

    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        return this.delegate.getColumnCapabilities(column);
    }

    @Nullable
    public RowIdSupplier getRowIdSupplier() {
        return this.delegate.getRowIdSupplier();
    }

    public static ParseException createException(Exception cause, String columnName, InputSource inputSource, SimpleSettableOffset offset) {
        return new ParseException(null, (Throwable)cause, ERROR_MESSAGE_FORMAT_STRING, new Object[]{inputSource.toString(), (long)offset.getOffset() + 1L, columnName});
    }
}

