/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit.scan;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Set;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.key.KeyOrder;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.msq.input.stage.StageInputSpec;
import org.apache.druid.msq.kernel.MixShuffleSpec;
import org.apache.druid.msq.kernel.QueryDefinition;
import org.apache.druid.msq.kernel.QueryDefinitionBuilder;
import org.apache.druid.msq.kernel.ShuffleSpec;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.querykit.DataSourcePlan;
import org.apache.druid.msq.querykit.QueryKit;
import org.apache.druid.msq.querykit.QueryKitSpec;
import org.apache.druid.msq.querykit.QueryKitUtils;
import org.apache.druid.msq.querykit.ShuffleSpecFactories;
import org.apache.druid.msq.querykit.ShuffleSpecFactory;
import org.apache.druid.msq.querykit.common.OffsetLimitStageProcessor;
import org.apache.druid.msq.querykit.scan.ScanQueryStageProcessor;
import org.apache.druid.query.Order;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;

public class ScanQueryKit
implements QueryKit<ScanQuery> {
    private final ObjectMapper jsonMapper;

    @Inject
    public ScanQueryKit(@Json ObjectMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    public static RowSignature getAndValidateSignature(ScanQuery scanQuery, ObjectMapper jsonMapper) {
        RowSignature scanSignature = scanQuery.getRowSignature();
        QueryKitUtils.verifyRowSignature(scanSignature);
        return scanSignature;
    }

    @Override
    public QueryDefinition makeQueryDefinition(QueryKitSpec queryKitSpec, ScanQuery originalQuery, ShuffleSpecFactory resultShuffleSpecFactory, int minStageNumber) {
        ShuffleSpec scanShuffleSpec;
        QueryDefinitionBuilder queryDefBuilder = QueryDefinition.builder(queryKitSpec.getQueryId());
        DataSourcePlan dataSourcePlan = DataSourcePlan.forDataSource(queryKitSpec, originalQuery.context(), originalQuery.getDataSource(), originalQuery.getQuerySegmentSpec(), originalQuery.getFilter(), null, minStageNumber, false);
        dataSourcePlan.getSubQueryDefBuilder().ifPresent(queryDefBuilder::addAll);
        ScanQuery queryToRun = originalQuery.withDataSource(dataSourcePlan.getNewDataSource());
        int firstStageNumber = Math.max(minStageNumber, queryDefBuilder.getNextStageNumber());
        RowSignature scanSignature = ScanQueryKit.getAndValidateSignature(queryToRun, this.jsonMapper);
        boolean hasLimitOrOffset = queryToRun.isLimited() || queryToRun.getScanRowsOffset() > 0L;
        RowSignature.Builder signatureBuilder = RowSignature.builder().addAll(scanSignature);
        Granularity segmentGranularity = QueryKitUtils.getSegmentGranularityFromContext(this.jsonMapper, queryToRun.getContext());
        ArrayList<KeyColumn> clusterByColumns = new ArrayList<KeyColumn>();
        for (OrderBy orderBy : queryToRun.getOrderBys()) {
            clusterByColumns.add(new KeyColumn(orderBy.getColumnName(), orderBy.getOrder() == Order.DESCENDING ? KeyOrder.DESCENDING : KeyOrder.ASCENDING));
        }
        clusterByColumns.add(new KeyColumn("__boost", KeyOrder.ASCENDING));
        signatureBuilder.add("__boost", ColumnType.LONG);
        ClusterBy clusterBy = QueryKitUtils.clusterByWithSegmentGranularity(new ClusterBy(clusterByColumns, 0), segmentGranularity);
        ShuffleSpec finalShuffleSpec = resultShuffleSpecFactory.build(clusterBy, false);
        RowSignature signatureToUse = QueryKitUtils.sortableSignature(QueryKitUtils.signatureWithSegmentGranularity(signatureBuilder.build(), segmentGranularity), clusterBy.getColumns());
        if (hasLimitOrOffset) {
            boolean requiresSort = clusterByColumns.stream().anyMatch(keyColumn -> !"__boost".equals(keyColumn.columnName()));
            if (requiresSort) {
                long limitHint = queryToRun.isLimited() && queryToRun.getScanRowsOffset() + queryToRun.getScanRowsLimit() > 0L ? queryToRun.getScanRowsOffset() + queryToRun.getScanRowsLimit() : -1L;
                scanShuffleSpec = ShuffleSpecFactories.singlePartitionWithLimit(limitHint).build(clusterBy, false);
            } else {
                scanShuffleSpec = MixShuffleSpec.instance();
            }
        } else {
            scanShuffleSpec = finalShuffleSpec;
        }
        queryDefBuilder.add(StageDefinition.builder(Math.max(minStageNumber, queryDefBuilder.getNextStageNumber())).inputs(dataSourcePlan.getInputSpecs()).broadcastInputs((Set<Integer>)dataSourcePlan.getBroadcastInputs()).shuffleSpec(scanShuffleSpec).signature(signatureToUse).maxWorkerCount(dataSourcePlan.getMaxWorkerCount(queryKitSpec)).processor(new ScanQueryStageProcessor(queryToRun)));
        if (hasLimitOrOffset) {
            queryDefBuilder.add(StageDefinition.builder(firstStageNumber + 1).inputs(new StageInputSpec(firstStageNumber)).signature(signatureToUse).maxWorkerCount(1).shuffleSpec(finalShuffleSpec).processor(new OffsetLimitStageProcessor(queryToRun.getScanRowsOffset(), queryToRun.isLimited() ? Long.valueOf(queryToRun.getScanRowsLimit()) : null)));
        }
        return queryDefBuilder.build();
    }
}

