/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.rpc;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.indexer.report.TaskReport;
import org.apache.druid.msq.counters.CounterSnapshotsTree;
import org.apache.druid.msq.exec.Controller;
import org.apache.druid.msq.indexing.MSQTaskList;
import org.apache.druid.msq.indexing.error.MSQErrorReport;
import org.apache.druid.msq.rpc.MSQResourceUtils;
import org.apache.druid.msq.rpc.ResourcePermissionMapper;
import org.apache.druid.server.security.AuthorizerMapper;

public class ControllerResource {
    private final Controller controller;
    private final ResourcePermissionMapper permissionMapper;
    private final AuthorizerMapper authorizerMapper;

    public ControllerResource(Controller controller, ResourcePermissionMapper permissionMapper, AuthorizerMapper authorizerMapper) {
        this.controller = controller;
        this.permissionMapper = permissionMapper;
        this.authorizerMapper = authorizerMapper;
    }

    @POST
    @Path(value="/partialKeyStatisticsInformation/{queryId}/{stageNumber}/{workerNumber}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response httpPostPartialKeyStatistics(Object partialKeyStatisticsObject, @PathParam(value="queryId") String queryId, @PathParam(value="stageNumber") int stageNumber, @PathParam(value="workerNumber") int workerNumber, @Context HttpServletRequest req) {
        MSQResourceUtils.authorizeAdminRequest(this.permissionMapper, this.authorizerMapper, req);
        this.controller.updatePartialKeyStatisticsInformation(stageNumber, workerNumber, partialKeyStatisticsObject);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @POST
    @Path(value="/doneReadingInput/{queryId}/{stageNumber}/{workerNumber}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response httpPostDoneReadingInput(@PathParam(value="stageNumber") int stageNumber, @PathParam(value="workerNumber") int workerNumber, @Context HttpServletRequest req) {
        MSQResourceUtils.authorizeAdminRequest(this.permissionMapper, this.authorizerMapper, req);
        this.controller.doneReadingInput(stageNumber, workerNumber);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @POST
    @Path(value="/workerError/{taskId}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response httpPostWorkerError(MSQErrorReport errorReport, @PathParam(value="taskId") String taskId, @Context HttpServletRequest req) {
        MSQResourceUtils.authorizeAdminRequest(this.permissionMapper, this.authorizerMapper, req);
        this.controller.workerError(errorReport);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @POST
    @Path(value="/workerWarning")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response httpPostWorkerWarning(List<MSQErrorReport> errorReport, @Context HttpServletRequest req) {
        MSQResourceUtils.authorizeAdminRequest(this.permissionMapper, this.authorizerMapper, req);
        this.controller.workerWarning(errorReport);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @POST
    @Path(value="/counters/{taskId}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response httpPostCounters(@PathParam(value="taskId") String taskId, CounterSnapshotsTree snapshotsTree, @Context HttpServletRequest req) {
        MSQResourceUtils.authorizeAdminRequest(this.permissionMapper, this.authorizerMapper, req);
        this.controller.updateCounters(taskId, snapshotsTree);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Path(value="/resultsComplete/{queryId}/{stageNumber}/{workerNumber}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response httpPostResultsComplete(Object resultObject, @PathParam(value="queryId") String queryId, @PathParam(value="stageNumber") int stageNumber, @PathParam(value="workerNumber") int workerNumber, @Context HttpServletRequest req) {
        MSQResourceUtils.authorizeAdminRequest(this.permissionMapper, this.authorizerMapper, req);
        this.controller.resultsComplete(queryId, stageNumber, workerNumber, resultObject);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @GET
    @Path(value="/taskList")
    @Produces(value={"application/json"})
    public Response httpGetTaskList(@Context HttpServletRequest req) {
        MSQResourceUtils.authorizeAdminRequest(this.permissionMapper, this.authorizerMapper, req);
        return Response.ok((Object)new MSQTaskList(this.controller.getWorkerIds())).build();
    }

    @GET
    @Path(value="/liveReports")
    @Produces(value={"application/json"})
    public Response httpGetLiveReports(@Context HttpServletRequest req) {
        MSQResourceUtils.authorizeAdminRequest(this.permissionMapper, this.authorizerMapper, req);
        TaskReport.ReportMap reports = this.controller.liveReports();
        if (reports == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)reports).build();
    }
}

