/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.shuffle.output;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.NoSuchElementException;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.java.util.common.logger.Logger;

public class FutureReadableFrameChannel
implements ReadableFrameChannel {
    private static final Logger log = new Logger(FutureReadableFrameChannel.class);
    private final ListenableFuture<ReadableFrameChannel> channelFuture;
    private ReadableFrameChannel channel;

    public FutureReadableFrameChannel(ListenableFuture<ReadableFrameChannel> channelFuture) {
        this.channelFuture = channelFuture;
    }

    public boolean isFinished() {
        if (this.populateChannel()) {
            return this.channel.isFinished();
        }
        return false;
    }

    public boolean canRead() {
        if (this.populateChannel()) {
            return this.channel.canRead();
        }
        return false;
    }

    public Frame read() {
        if (this.populateChannel()) {
            return this.channel.read();
        }
        throw new NoSuchElementException();
    }

    public ListenableFuture<?> readabilityFuture() {
        if (this.populateChannel()) {
            return this.channel.readabilityFuture();
        }
        return FutureUtils.transformAsync(this.channelFuture, ignored -> this.readabilityFuture());
    }

    public void close() {
        if (this.populateChannel()) {
            this.channel.close();
        } else {
            this.channelFuture.cancel(true);
            try {
                ReadableFrameChannel theChannel = (ReadableFrameChannel)FutureUtils.getUncheckedImmediately(this.channelFuture);
                try {
                    theChannel.close();
                }
                catch (Throwable t) {
                    log.noStackTrace().warn(t, "Failed to close channel", new Object[0]);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private boolean populateChannel() {
        if (this.channel != null) {
            return true;
        }
        if (this.channelFuture.isDone()) {
            this.channel = (ReadableFrameChannel)FutureUtils.getUncheckedImmediately(this.channelFuture);
            return true;
        }
        return false;
    }
}

