/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.statistics;

import java.util.Collections;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.druid.frame.key.ClusterByPartition;
import org.apache.druid.frame.key.ClusterByPartitions;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.statistics.KeyCollector;

public class DelegateOrMinKeyCollector<TDelegate extends KeyCollector<TDelegate>>
implements KeyCollector<DelegateOrMinKeyCollector<TDelegate>> {
    private final Comparator<RowKey> comparator;
    @Nullable
    private TDelegate delegate;
    @Nullable
    private RowKey minKey;

    DelegateOrMinKeyCollector(Comparator<RowKey> comparator, @Nullable TDelegate delegate, @Nullable RowKey minKey) {
        this.comparator = comparator;
        this.delegate = delegate;
        this.minKey = minKey;
        if (delegate != null && minKey != null) {
            throw new ISE("Cannot have both 'delegate' and 'minKey'", new Object[0]);
        }
    }

    public Optional<TDelegate> getDelegate() {
        return Optional.ofNullable(this.delegate);
    }

    @Override
    public void add(RowKey key, long weight) {
        if (this.delegate != null) {
            this.delegate.add(key, weight);
        } else if (this.minKey == null || this.comparator.compare(key, this.minKey) < 0) {
            this.minKey = key;
        }
    }

    @Override
    public void addAll(DelegateOrMinKeyCollector<TDelegate> other) {
        if (this.delegate != null) {
            if (other.delegate != null) {
                this.delegate.addAll(other.delegate);
            } else if (other.minKey != null) {
                this.delegate.add(other.minKey, 1L);
            }
        } else if (!other.isEmpty()) {
            this.add(other.minKey(), 1L);
        }
    }

    @Override
    public boolean isEmpty() {
        if (this.delegate != null) {
            return this.delegate.isEmpty();
        }
        return this.minKey == null;
    }

    @Override
    public long estimatedTotalWeight() {
        if (this.delegate != null) {
            return this.delegate.estimatedTotalWeight();
        }
        return this.minKey != null ? 1L : 0L;
    }

    @Override
    public int estimatedRetainedKeys() {
        if (this.delegate != null) {
            return this.delegate.estimatedRetainedKeys();
        }
        return this.minKey != null ? 1 : 0;
    }

    @Override
    public long estimatedRetainedBytes() {
        if (this.delegate != null) {
            return this.delegate.estimatedRetainedBytes();
        }
        return this.minKey != null ? (long)this.minKey.estimatedObjectSizeBytes() : 0L;
    }

    @Override
    public boolean downSample() {
        if (this.delegate != null && !this.delegate.downSample()) {
            this.minKey = this.delegate.isEmpty() ? null : this.minKey();
            this.delegate = null;
        }
        return true;
    }

    @Override
    public RowKey minKey() {
        if (this.delegate != null) {
            return this.delegate.minKey();
        }
        if (this.minKey != null) {
            return this.minKey;
        }
        throw new NoSuchElementException();
    }

    @Override
    public ClusterByPartitions generatePartitionsWithTargetWeight(long targetWeight) {
        if (targetWeight <= 0L) {
            throw new IAE("targetPartitionWeight must be positive, but was [%d]", new Object[]{targetWeight});
        }
        if (this.delegate != null) {
            return this.delegate.generatePartitionsWithTargetWeight(targetWeight);
        }
        if (this.minKey != null) {
            return new ClusterByPartitions(Collections.singletonList(new ClusterByPartition(this.minKey, null)));
        }
        return ClusterByPartitions.oneUniversalPartition();
    }

    @Override
    public int sketchAccuracyFactor() {
        return this.delegate == null ? Integer.MIN_VALUE : this.delegate.sketchAccuracyFactor();
    }

    public String toString() {
        return "DelegateOrMinKeyCollector{delegate=" + String.valueOf(this.delegate) + ", minKey=" + String.valueOf(this.minKey) + "}";
    }
}

