/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.indexer.HadoopDruidIndexerConfig;
import org.apache.druid.indexer.granularity.GranularitySpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.collect.Utils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Mapper;
import org.joda.time.ReadableInstant;

public abstract class HadoopDruidIndexerMapper<KEYOUT, VALUEOUT>
extends Mapper<Object, Object, KEYOUT, VALUEOUT> {
    private static final Logger log = new Logger(HadoopDruidIndexerMapper.class);
    protected HadoopDruidIndexerConfig config;
    private InputRowParser parser;
    protected GranularitySpec granularitySpec;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.config = HadoopDruidIndexerConfig.fromConfiguration(context.getConfiguration());
        this.parser = this.config.getParser();
        this.granularitySpec = this.config.getGranularitySpec();
    }

    public HadoopDruidIndexerConfig getConfig() {
        return this.config;
    }

    protected void map(Object key, Object value, Mapper.Context context) throws IOException, InterruptedException {
        try {
            List<InputRow> inputRows = HadoopDruidIndexerMapper.parseInputRow(value, this.parser);
            for (InputRow inputRow : inputRows) {
                try {
                    if (inputRow == null) {
                        log.debug("Throwing away row [%s]", new Object[]{value});
                        context.getCounter((Enum)HadoopDruidIndexerConfig.IndexJobCounters.ROWS_THROWN_AWAY_COUNTER).increment(1L);
                        continue;
                    }
                    if (!Intervals.ETERNITY.contains((ReadableInstant)inputRow.getTimestamp())) {
                        String errorMsg = StringUtils.format((String)"Encountered row with timestamp that cannot be represented as a long: [%s]", (Object[])new Object[]{inputRow});
                        throw new ParseException(null, errorMsg, new Object[0]);
                    }
                    if (this.granularitySpec.inputIntervals().isEmpty() || this.granularitySpec.bucketInterval(DateTimes.utc((long)inputRow.getTimestampFromEpoch())).isPresent()) {
                        this.innerMap(inputRow, context);
                        continue;
                    }
                    context.getCounter((Enum)HadoopDruidIndexerConfig.IndexJobCounters.ROWS_THROWN_AWAY_COUNTER).increment(1L);
                }
                catch (ParseException pe) {
                    this.handleParseException(pe, context);
                }
            }
        }
        catch (ParseException pe) {
            this.handleParseException(pe, context);
        }
        catch (RuntimeException e) {
            throw new RE((Throwable)e, "Failure on row[%s]", new Object[]{value});
        }
    }

    private void handleParseException(ParseException pe, Mapper.Context context) {
        long rowsProcessedWithError;
        long rowsUnparseable;
        context.getCounter((Enum)HadoopDruidIndexerConfig.IndexJobCounters.INVALID_ROW_COUNTER).increment(1L);
        Counter unparseableCounter = context.getCounter((Enum)HadoopDruidIndexerConfig.IndexJobCounters.ROWS_UNPARSEABLE_COUNTER);
        Counter processedWithErrorsCounter = context.getCounter((Enum)HadoopDruidIndexerConfig.IndexJobCounters.ROWS_PROCESSED_WITH_ERRORS_COUNTER);
        if (pe.isFromPartiallyValidRow()) {
            processedWithErrorsCounter.increment(1L);
        } else {
            unparseableCounter.increment(1L);
        }
        if (this.config.isLogParseExceptions()) {
            log.error((Throwable)pe, "Encountered parse exception: ", new Object[0]);
        }
        if ((rowsUnparseable = unparseableCounter.getValue()) + (rowsProcessedWithError = processedWithErrorsCounter.getValue()) > (long)this.config.getMaxParseExceptions()) {
            log.error("Max parse exceptions exceeded, terminating task...", new Object[0]);
            throw new RuntimeException("Max parse exceptions exceeded, terminating task...", pe);
        }
    }

    private static List<InputRow> parseInputRow(Object value, InputRowParser parser) {
        if (parser instanceof StringInputRowParser && value instanceof Text) {
            return Utils.nullableListOf((Object[])new InputRow[]{((StringInputRowParser)parser).parse(value.toString())});
        }
        if (value instanceof InputRow) {
            return ImmutableList.of((Object)((InputRow)value));
        }
        if (value == null) {
            return Utils.nullableListOf((Object[])new InputRow[]{null});
        }
        return parser.parseBatch(value);
    }

    protected abstract void innerMap(InputRow var1, Mapper.Context var2) throws IOException, InterruptedException;
}

