/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.RetrieveUnusedSegmentsAction;
import org.apache.druid.indexing.common.actions.SegmentMetadataUpdateAction;
import org.apache.druid.indexing.common.task.AbstractFixedIntervalTask;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class RestoreTask
extends AbstractFixedIntervalTask {
    public static final String TYPE = "restore";
    private static final Logger log = new Logger(RestoreTask.class);

    public RestoreTask(@JsonProperty(value="id") String id, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="context") Map<String, Object> context) {
        super(RestoreTask.getOrMakeId(id, TYPE, dataSource, interval), dataSource, interval, context);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    @JsonIgnore
    public Set<ResourceAction> getInputSourceResources() {
        return ImmutableSet.of();
    }

    @Override
    public TaskStatus runTask(TaskToolbox toolbox) throws Exception {
        TaskLock myLock = this.getAndCheckLock(toolbox);
        List<DataSegment> unusedSegments = toolbox.getTaskActionClient().submit(new RetrieveUnusedSegmentsAction(myLock.getDataSource(), myLock.getInterval(), null, null, null));
        for (DataSegment unusedSegment : unusedSegments) {
            if (unusedSegment.getVersion().compareTo(myLock.getVersion()) > 0) {
                throw new ISE("Unused segment[%s] has version[%s] > task version[%s]", new Object[]{unusedSegment.getId(), unusedSegment.getVersion(), myLock.getVersion()});
            }
            log.info("OK to restore segment: %s", new Object[]{unusedSegment.getId()});
        }
        ArrayList<DataSegment> restoredSegments = new ArrayList<DataSegment>();
        for (DataSegment segment : unusedSegments) {
            DataSegment restored = toolbox.getDataSegmentArchiver().restore(segment);
            if (restored != null) {
                restoredSegments.add(restored);
                continue;
            }
            log.info("Segment [%s] did not move, not updating metadata", new Object[]{segment.getId()});
        }
        if (restoredSegments.isEmpty()) {
            log.info("No segments restored", new Object[0]);
        } else {
            toolbox.getTaskActionClient().submit(new SegmentMetadataUpdateAction((Set<DataSegment>)ImmutableSet.copyOf(restoredSegments)));
        }
        return TaskStatus.success((String)this.getId());
    }
}

