/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Phaser;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.indexer.partitions.DimensionRangePartitionsSpec;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.task.batch.parallel.DimensionDistributionReport;
import org.apache.druid.indexing.common.task.batch.parallel.InputSourceSplitParallelIndexTaskRunner;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.PartialDimensionDistributionTask;
import org.apache.druid.indexing.common.task.batch.parallel.SubTaskSpec;
import org.apache.druid.indexing.common.task.batch.parallel.distribution.StringDistribution;
import org.apache.druid.indexing.common.task.batch.parallel.distribution.StringSketchMerger;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.timeline.partition.PartitionBoundaries;
import org.joda.time.DateTime;
import org.joda.time.Interval;

class PartialDimensionDistributionParallelIndexTaskRunner
extends InputSourceSplitParallelIndexTaskRunner<PartialDimensionDistributionTask, DimensionDistributionReport> {
    private static final Logger log = new Logger(PartialDimensionDistributionParallelIndexTaskRunner.class);
    private static final String PHASE_NAME = "partial dimension distribution";
    private final ExecutorService executor = Execs.singleThreaded((String)"DimDistributionWriter-%s");
    private final Phaser allReportsProcessedPhaser = new Phaser(1);
    private final Map<Interval, Set<String>> intervalToTaskIds = new HashMap<Interval, Set<String>>();
    private final File tempDistributionsDir = this.createDistributionsDir();

    PartialDimensionDistributionParallelIndexTaskRunner(TaskToolbox toolbox, String taskId, String groupId, String baseSubtaskSpecName, ParallelIndexIngestionSpec ingestionSchema, Map<String, Object> context) {
        super(toolbox, taskId, groupId, baseSubtaskSpecName, ingestionSchema, context);
    }

    @Override
    public String getName() {
        return PHASE_NAME;
    }

    @Override
    public void collectReport(DimensionDistributionReport report) {
        super.collectReport(new DimensionDistributionReport(report.getTaskId(), null));
        if (this.executor.isShutdown()) {
            throw new ISE("Executor is already shutdown. Cannot process more reports.", new Object[0]);
        }
        this.allReportsProcessedPhaser.register();
        this.executor.submit(() -> this.extractDistributionsFromReport(report));
    }

    public Map<Interval, PartitionBoundaries> getIntervalToPartitionBoundaries(DimensionRangePartitionsSpec partitionsSpec) {
        this.waitToProcessPendingReports();
        if (this.getStopReason() != null) {
            throw new ISE("DimensionDistributionPhaseRunner has been stopped. %s", new Object[]{this.getStopReason()});
        }
        Set<String> succeededTaskIds = super.getReports().keySet();
        HashMap<Interval, PartitionBoundaries> intervalToPartitions = new HashMap<Interval, PartitionBoundaries>();
        this.intervalToTaskIds.forEach((interval, subTaskIds) -> {
            File intervalDir = this.getIntervalDistributionDir((Interval)interval);
            StringSketchMerger merger = new StringSketchMerger();
            subTaskIds.stream().filter(succeededTaskIds::contains).map(subTaskId -> this.readDistributionFromFile(intervalDir, (String)subTaskId)).forEach(merger::merge);
            StringDistribution mergedDistribution = merger.getResult();
            Integer targetRowsPerSegment = partitionsSpec.getTargetRowsPerSegment();
            PartitionBoundaries partitions = targetRowsPerSegment == null ? mergedDistribution.getEvenPartitionsByMaxSize(partitionsSpec.getMaxRowsPerSegment()) : mergedDistribution.getEvenPartitionsByTargetSize(targetRowsPerSegment);
            intervalToPartitions.put((Interval)interval, partitions);
        });
        this.cleanupDistributionsDir();
        return intervalToPartitions;
    }

    private void extractDistributionsFromReport(DimensionDistributionReport report) {
        try {
            log.debug("Started writing distributions from task [%s]", new Object[]{report.getTaskId()});
            Map<Interval, StringDistribution> distributions = report.getIntervalToDistribution();
            if (distributions == null || distributions.isEmpty()) {
                log.debug("No dimension distribution received from task [%s]", new Object[]{report.getTaskId()});
                return;
            }
            distributions.forEach((interval, distribution) -> {
                String subTaskId;
                Set taskIds = this.intervalToTaskIds.computeIfAbsent((Interval)interval, i -> new HashSet());
                if (!taskIds.contains(subTaskId = report.getTaskId())) {
                    this.writeDistributionToFile((Interval)interval, subTaskId, (StringDistribution)distribution);
                    taskIds.add(subTaskId);
                }
            });
            log.debug("Finished writing distributions from task [%s]", new Object[]{report.getTaskId()});
        }
        finally {
            this.allReportsProcessedPhaser.arriveAndDeregister();
        }
    }

    private void writeDistributionToFile(Interval interval, String subTaskId, StringDistribution distribution) {
        try {
            File intervalDir = this.getIntervalDistributionDir(interval);
            FileUtils.mkdirp((File)intervalDir);
            File distributionJsonFile = this.getDistributionJsonFile(intervalDir, subTaskId);
            this.getToolbox().getJsonMapper().writeValue(distributionJsonFile, (Object)distribution);
        }
        catch (IOException e) {
            String errorMsg = StringUtils.format((String)"Exception while writing distribution file for interval [%s], task [%s]", (Object[])new Object[]{interval, subTaskId});
            this.stopGracefully(errorMsg);
            throw new ISE((Throwable)e, errorMsg, new Object[0]);
        }
    }

    private StringDistribution readDistributionFromFile(File intervalDir, String subTaskId) {
        try {
            File distributionJsonFile = this.getDistributionJsonFile(intervalDir, subTaskId);
            return (StringDistribution)this.getToolbox().getJsonMapper().readValue(distributionJsonFile, StringDistribution.class);
        }
        catch (IOException e) {
            throw new ISE((Throwable)e, "Error while reading distribution for interval [%s], task [%s]", new Object[]{intervalDir.getName(), subTaskId});
        }
    }

    private File getIntervalDistributionDir(Interval interval) {
        return new File(this.tempDistributionsDir, this.toIntervalString(interval));
    }

    private File getDistributionJsonFile(File intervalDir, String subTaskId) {
        return new File(intervalDir, subTaskId);
    }

    private void waitToProcessPendingReports() {
        log.info("Waiting to extract distributions from sub-task reports.", new Object[0]);
        try {
            this.allReportsProcessedPhaser.arriveAndAwaitAdvance();
            this.executor.shutdownNow();
        }
        catch (Exception e) {
            throw new ISE((Throwable)e, "Exception while waiting to extract distributions.", new Object[0]);
        }
    }

    private File createDistributionsDir() {
        File taskTempDir = this.getToolbox().getConfig().getTaskTempDir(this.getTaskId());
        File distributionsDir = new File(taskTempDir, "dimension_distributions");
        try {
            FileUtils.mkdirp((File)distributionsDir);
            return distributionsDir;
        }
        catch (IOException e) {
            throw new ISE((Throwable)e, "Could not create temp distribution directory.", new Object[0]);
        }
    }

    private void cleanupDistributionsDir() {
        try {
            FileUtils.deleteDirectory((File)this.tempDistributionsDir);
        }
        catch (IOException e) {
            log.warn((Throwable)e, "Could not delete temp distribution directory.", new Object[0]);
        }
    }

    private String toIntervalString(Interval interval) {
        return String.valueOf(new DateTime(interval.getStartMillis(), interval.getChronology())) + "_" + String.valueOf(new DateTime(interval.getEndMillis(), interval.getChronology()));
    }

    @Override
    SubTaskSpec<PartialDimensionDistributionTask> createSubTaskSpec(final String id, String groupId, String supervisorTaskId, Map<String, Object> context, InputSplit split, final ParallelIndexIngestionSpec subTaskIngestionSpec) {
        return new SubTaskSpec<PartialDimensionDistributionTask>(id, groupId, supervisorTaskId, context, split){

            @Override
            public PartialDimensionDistributionTask newSubTask(int numAttempts) {
                return new PartialDimensionDistributionTask(null, this.getGroupId(), null, this.getSupervisorTaskId(), id, numAttempts, subTaskIngestionSpec, this.getContext());
            }
        };
    }
}

