/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.partition;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexing.common.task.batch.partition.PartitionAnalysis;
import org.apache.druid.java.util.common.IAE;
import org.joda.time.Interval;

public class LinearPartitionAnalysis
implements PartitionAnalysis<Integer, DynamicPartitionsSpec> {
    private final Set<Interval> intervals = new HashSet<Interval>();
    private final DynamicPartitionsSpec partitionsSpec;

    public LinearPartitionAnalysis(DynamicPartitionsSpec partitionsSpec) {
        this.partitionsSpec = partitionsSpec;
    }

    @Override
    public DynamicPartitionsSpec getPartitionsSpec() {
        return this.partitionsSpec;
    }

    @Override
    public void updateBucket(Interval interval, Integer bucketAnalysis) {
        Preconditions.checkArgument((bucketAnalysis == 1 ? 1 : 0) != 0, (Object)"There should be only one bucket with linear partitioining");
        this.intervals.add(interval);
    }

    @Override
    public Integer getBucketAnalysis(Interval interval) {
        if (this.intervals.contains(interval)) {
            return 1;
        }
        throw new IAE("Missing bucket analysis for interval[%s]", new Object[]{interval});
    }

    @Override
    public Set<Interval> getAllIntervalsToIndex() {
        return this.intervals;
    }

    @Override
    public int getNumTimePartitions() {
        return this.intervals.size();
    }
}

