/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.compact;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.client.indexing.ClientCompactionTaskQuery;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.indexer.CompactionEngine;
import org.apache.druid.indexing.compact.CompactionJob;
import org.apache.druid.indexing.compact.CompactionJobParams;
import org.apache.druid.indexing.compact.CompactionJobTemplate;
import org.apache.druid.indexing.input.DruidInputSource;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.server.compaction.CompactionCandidate;
import org.apache.druid.server.compaction.CompactionCandidateSearchPolicy;
import org.apache.druid.server.compaction.CompactionSlotManager;
import org.apache.druid.server.compaction.DataSourceCompactibleSegmentIterator;
import org.apache.druid.server.compaction.NewestSegmentFirstPolicy;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.duty.CompactSegments;
import org.apache.druid.timeline.SegmentTimeline;
import org.joda.time.Interval;

public class CompactionConfigBasedJobTemplate
implements CompactionJobTemplate {
    private final DataSourceCompactionConfig config;

    public CompactionConfigBasedJobTemplate(DataSourceCompactionConfig config) {
        this.config = config;
    }

    @Override
    @Nullable
    public Granularity getSegmentGranularity() {
        return this.config.getSegmentGranularity();
    }

    @Override
    public List<CompactionJob> createCompactionJobs(DruidInputSource source, CompactionJobParams params) {
        DataSourceCompactibleSegmentIterator segmentIterator = this.getCompactibleCandidates(source, params);
        ArrayList<CompactionJob> jobs = new ArrayList<CompactionJob>();
        while (segmentIterator.hasNext()) {
            CompactionCandidate candidate = segmentIterator.next();
            ClientCompactionTaskQuery taskPayload = CompactSegments.createCompactionTask((CompactionCandidate)candidate, (DataSourceCompactionConfig)this.config, (CompactionEngine)params.getClusterCompactionConfig().getEngine());
            jobs.add(new CompactionJob(taskPayload, candidate, CompactionSlotManager.computeSlotsRequiredForTask((ClientCompactionTaskQuery)taskPayload)));
        }
        return jobs;
    }

    public String getType() {
        throw DruidException.defensive((String)"This template cannot be serialized. It is an adapter used to create jobs using a legacy DataSourceCompactionConfig. Do not use this template in a supervisor spec directly. Use types [compactCatalog], [compactMsq] or [compactInline] instead.", (Object[])new Object[0]);
    }

    DataSourceCompactibleSegmentIterator getCompactibleCandidates(DruidInputSource source, CompactionJobParams params) {
        this.validateInput(source);
        Interval searchInterval = Objects.requireNonNull(source.getInterval());
        SegmentTimeline timeline = params.getTimeline(this.config.getDataSource());
        DataSourceCompactibleSegmentIterator iterator = new DataSourceCompactibleSegmentIterator(this.config, timeline, Intervals.complementOf((Interval)searchInterval), (CompactionCandidateSearchPolicy)new NewestSegmentFirstPolicy(null));
        iterator.getCompactedSegments().forEach(entry -> params.getSnapshotBuilder().addToComplete(entry));
        return iterator;
    }

    private void validateInput(DruidInputSource druidInputSource) {
        if (!druidInputSource.getDataSource().equals(this.config.getDataSource())) {
            throw InvalidInput.exception((String)"Datasource[%s] in compaction config does not match datasource[%s] in input source", (Object[])new Object[]{this.config.getDataSource(), druidInputSource.getDataSource()});
        }
    }
}

