/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.compact;

import org.apache.druid.server.compaction.CompactionSnapshotBuilder;
import org.apache.druid.server.coordinator.ClusterCompactionConfig;
import org.apache.druid.timeline.SegmentTimeline;
import org.joda.time.DateTime;

public class CompactionJobParams {
    private final DateTime scheduleStartTime;
    private final TimelineProvider timelineProvider;
    private final ClusterCompactionConfig clusterCompactionConfig;
    private final CompactionSnapshotBuilder snapshotBuilder;

    public CompactionJobParams(DateTime scheduleStartTime, ClusterCompactionConfig clusterCompactionConfig, TimelineProvider timelineProvider, CompactionSnapshotBuilder snapshotBuilder) {
        this.scheduleStartTime = scheduleStartTime;
        this.clusterCompactionConfig = clusterCompactionConfig;
        this.timelineProvider = timelineProvider;
        this.snapshotBuilder = snapshotBuilder;
    }

    public DateTime getScheduleStartTime() {
        return this.scheduleStartTime;
    }

    public ClusterCompactionConfig getClusterCompactionConfig() {
        return this.clusterCompactionConfig;
    }

    public SegmentTimeline getTimeline(String dataSource) {
        return this.timelineProvider.getTimelineForDataSource(dataSource);
    }

    public CompactionSnapshotBuilder getSnapshotBuilder() {
        return this.snapshotBuilder;
    }

    @FunctionalInterface
    public static interface TimelineProvider {
        public SegmentTimeline getTimelineForDataSource(String var1);
    }
}

