/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.compact;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.client.broker.BrokerClient;
import org.apache.druid.client.indexing.ClientCompactionRunnerInfo;
import org.apache.druid.indexer.CompactionEngine;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.actions.TaskActionClientFactory;
import org.apache.druid.indexing.compact.CompactionJobQueue;
import org.apache.druid.indexing.compact.CompactionScheduler;
import org.apache.druid.indexing.compact.CompactionSupervisor;
import org.apache.druid.indexing.compact.DruidInputSourceFactory;
import org.apache.druid.indexing.compact.LocalOverlordClient;
import org.apache.druid.indexing.overlord.GlobalTaskLockbox;
import org.apache.druid.indexing.overlord.TaskMaster;
import org.apache.druid.indexing.overlord.TaskQueryTool;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.apache.druid.indexing.overlord.TaskRunnerListener;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Stopwatch;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.metadata.SegmentsMetadataManagerConfig;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.server.compaction.CompactionRunSimulator;
import org.apache.druid.server.compaction.CompactionSimulateResult;
import org.apache.druid.server.compaction.CompactionStatusTracker;
import org.apache.druid.server.coordinator.AutoCompactionSnapshot;
import org.apache.druid.server.coordinator.ClusterCompactionConfig;
import org.apache.druid.server.coordinator.CompactionConfigValidationResult;
import org.apache.druid.server.coordinator.CoordinatorOverlordServiceConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.DruidCompactionConfig;
import org.apache.druid.server.coordinator.stats.CoordinatorStat;
import org.apache.druid.server.coordinator.stats.RowKey;
import org.apache.druid.server.coordinator.stats.Stats;

public class OverlordCompactionScheduler
implements CompactionScheduler {
    private static final Logger log = new Logger(OverlordCompactionScheduler.class);
    private static final long DEFAULT_SCHEDULE_PERIOD_MILLIS = 900000L;
    private final SegmentsMetadataManager segmentManager;
    private final LocalOverlordClient overlordClient;
    private final BrokerClient brokerClient;
    private final ServiceEmitter emitter;
    private final ObjectMapper objectMapper;
    private final TaskMaster taskMaster;
    private final Supplier<DruidCompactionConfig> compactionConfigSupplier;
    private final ConcurrentHashMap<String, CompactionSupervisor> activeSupervisors;
    private final AtomicReference<Map<String, AutoCompactionSnapshot>> datasourceToCompactionSnapshot;
    private final AtomicBoolean shouldRecomputeJobsForAnyDatasource = new AtomicBoolean(false);
    private final AtomicReference<CompactionJobQueue> latestJobQueue;
    private final ScheduledExecutorService executor;
    private final CompactionStatusTracker statusTracker;
    private final TaskActionClientFactory taskActionClientFactory;
    private final DruidInputSourceFactory druidInputSourceFactory;
    private final GlobalTaskLockbox taskLockbox;
    private final TaskRunnerListener taskRunnerListener;
    private final AtomicBoolean isLeader = new AtomicBoolean(false);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final boolean shouldPollSegments;
    private final long schedulePeriodMillis;

    @Inject
    public OverlordCompactionScheduler(TaskMaster taskMaster, GlobalTaskLockbox taskLockbox, TaskQueryTool taskQueryTool, SegmentsMetadataManager segmentManager, SegmentsMetadataManagerConfig segmentManagerConfig, Supplier<DruidCompactionConfig> compactionConfigSupplier, CompactionStatusTracker statusTracker, CoordinatorOverlordServiceConfig coordinatorOverlordServiceConfig, TaskActionClientFactory taskActionClientFactory, DruidInputSourceFactory druidInputSourceFactory, ScheduledExecutorFactory executorFactory, BrokerClient brokerClient, ServiceEmitter emitter, ObjectMapper objectMapper) {
        long segmentPollPeriodMillis = segmentManagerConfig.getPollDuration().toStandardDuration().getMillis();
        this.schedulePeriodMillis = Math.min(900000L, segmentPollPeriodMillis);
        this.segmentManager = segmentManager;
        this.emitter = emitter;
        this.objectMapper = objectMapper;
        this.taskMaster = taskMaster;
        this.taskLockbox = taskLockbox;
        this.compactionConfigSupplier = compactionConfigSupplier;
        this.executor = executorFactory.create(1, "CompactionScheduler-%s");
        this.statusTracker = statusTracker;
        this.shouldPollSegments = segmentManager != null && !coordinatorOverlordServiceConfig.isEnabled();
        this.overlordClient = new LocalOverlordClient(taskMaster, taskQueryTool, objectMapper);
        this.brokerClient = brokerClient;
        this.activeSupervisors = new ConcurrentHashMap();
        this.datasourceToCompactionSnapshot = new AtomicReference();
        this.latestJobQueue = new AtomicReference();
        this.taskActionClientFactory = taskActionClientFactory;
        this.druidInputSourceFactory = druidInputSourceFactory;
        this.taskRunnerListener = new TaskRunnerListener(){

            @Override
            public String getListenerId() {
                return "OverlordCompactionScheduler";
            }

            @Override
            public void locationChanged(String taskId, TaskLocation newLocation) {
            }

            @Override
            public void statusChanged(String taskId, TaskStatus status) {
                if (status.isComplete()) {
                    OverlordCompactionScheduler.this.onTaskFinished(taskId, status);
                    OverlordCompactionScheduler.this.launchPendingJobs();
                }
            }
        };
    }

    @LifecycleStart
    public synchronized void start() {
    }

    @LifecycleStop
    public synchronized void stop() {
        this.executor.shutdownNow();
    }

    @Override
    public void becomeLeader() {
        if (this.isLeader.compareAndSet(false, true)) {
            this.scheduleOnExecutor(this::scheduledRun, 1000L);
        }
    }

    @Override
    public void stopBeingLeader() {
        this.isLeader.set(false);
    }

    @Override
    public boolean isRunning() {
        return this.started.get();
    }

    @Override
    public CompactionConfigValidationResult validateCompactionConfig(DataSourceCompactionConfig compactionConfig) {
        if (compactionConfig == null) {
            return CompactionConfigValidationResult.failure((String)"Cannot be null", (Object[])new Object[0]);
        }
        return ClientCompactionRunnerInfo.validateCompactionConfig((DataSourceCompactionConfig)compactionConfig, (CompactionEngine)this.getLatestClusterConfig().getEngine());
    }

    @Override
    public void startCompaction(String dataSourceName, CompactionSupervisor supervisor) {
        if (this.isEnabled()) {
            this.activeSupervisors.put(dataSourceName, supervisor);
            if (this.started.get()) {
                this.shouldRecomputeJobsForAnyDatasource.set(true);
                this.scheduleOnExecutor(() -> this.recreateJobs(dataSourceName, supervisor), 0L);
            }
        }
    }

    @Override
    public void stopCompaction(String dataSourceName) {
        this.activeSupervisors.remove(dataSourceName);
        this.updateQueueIfComputed(queue -> queue.removeJobs(dataSourceName));
        this.statusTracker.removeDatasource(dataSourceName);
    }

    private synchronized void initState() {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        log.info("Starting compaction scheduler with period [%d] millis.", new Object[]{this.schedulePeriodMillis});
        Optional<TaskRunner> taskRunnerOptional = this.taskMaster.getTaskRunner();
        if (taskRunnerOptional.isPresent()) {
            ((TaskRunner)taskRunnerOptional.get()).registerListener(this.taskRunnerListener, this.executor);
        }
        if (this.shouldPollSegments) {
            this.segmentManager.startPollingDatabasePeriodically();
        }
    }

    private synchronized void cleanupState() {
        if (!this.started.compareAndSet(true, false)) {
            return;
        }
        log.info("Stopping compaction scheduler.", new Object[0]);
        Optional<TaskRunner> taskRunnerOptional = this.taskMaster.getTaskRunner();
        if (taskRunnerOptional.isPresent()) {
            ((TaskRunner)taskRunnerOptional.get()).unregisterListener(this.taskRunnerListener.getListenerId());
        }
        this.statusTracker.stop();
        this.activeSupervisors.clear();
        this.latestJobQueue.set(null);
        if (this.shouldPollSegments) {
            this.segmentManager.stopPollingDatabasePeriodically();
        }
    }

    @Override
    public boolean isEnabled() {
        return ((DruidCompactionConfig)this.compactionConfigSupplier.get()).isUseSupervisors();
    }

    private synchronized void scheduledRun() {
        if (!this.isLeader.get()) {
            this.cleanupState();
            return;
        }
        if (this.isEnabled()) {
            this.initState();
            try {
                this.resetCompactionJobQueue();
            }
            catch (Exception e) {
                log.error((Throwable)e, "Error processing compaction queue. Continuing schedule.", new Object[0]);
            }
            this.scheduleOnExecutor(this::scheduledRun, this.schedulePeriodMillis);
        } else {
            this.cleanupState();
            this.scheduleOnExecutor(this::scheduledRun, this.schedulePeriodMillis);
        }
    }

    private synchronized void resetCompactionJobQueue() {
        this.latestJobQueue.set(null);
        Stopwatch runDuration = Stopwatch.createStarted();
        DataSourcesSnapshot dataSourcesSnapshot = this.getDatasourceSnapshot();
        CompactionJobQueue queue = new CompactionJobQueue(dataSourcesSnapshot, this.getLatestClusterConfig(), this.statusTracker, this.taskActionClientFactory, this.taskLockbox, (OverlordClient)this.overlordClient, this.brokerClient, this.objectMapper);
        this.latestJobQueue.set(queue);
        this.statusTracker.resetActiveDatasources(this.activeSupervisors.keySet());
        this.statusTracker.onSegmentTimelineUpdated(dataSourcesSnapshot.getSnapshotTime());
        this.shouldRecomputeJobsForAnyDatasource.set(false);
        this.activeSupervisors.forEach(this::createAndEnqueueJobs);
        this.launchPendingJobs();
        queue.getRunStats().forEachStat(this::emitStat);
        this.emitStat(Stats.Compaction.SCHEDULER_RUN_TIME, RowKey.empty(), runDuration.millisElapsed());
    }

    private synchronized void launchPendingJobs() {
        this.updateQueueIfComputed(queue -> {
            queue.runReadyJobs();
            this.updateCompactionSnapshots((CompactionJobQueue)queue);
        });
    }

    private synchronized void recreateJobs(String dataSource, CompactionSupervisor supervisor) {
        if (this.shouldRecomputeJobsForAnyDatasource.get()) {
            this.createAndEnqueueJobs(dataSource, supervisor);
        }
    }

    private synchronized void createAndEnqueueJobs(String dataSource, CompactionSupervisor supervisor) {
        this.updateQueueIfComputed(queue -> queue.createAndEnqueueJobs(supervisor, this.druidInputSourceFactory.create(dataSource, Intervals.ETERNITY)));
    }

    private void updateQueueIfComputed(Consumer<CompactionJobQueue> operation) {
        CompactionJobQueue queue = this.latestJobQueue.get();
        if (queue != null) {
            operation.accept(queue);
        }
    }

    private void onTaskFinished(String taskId, TaskStatus taskStatus) {
        this.statusTracker.onTaskFinished(taskId, taskStatus);
        this.updateQueueIfComputed(queue -> {
            queue.onTaskFinished(taskId, taskStatus);
            this.updateCompactionSnapshots((CompactionJobQueue)queue);
        });
    }

    private void updateCompactionSnapshots(CompactionJobQueue queue) {
        this.datasourceToCompactionSnapshot.set(queue.getSnapshots());
    }

    @Override
    public AutoCompactionSnapshot getCompactionSnapshot(String dataSource) {
        if (!this.activeSupervisors.containsKey(dataSource)) {
            return AutoCompactionSnapshot.builder((String)dataSource).withStatus(AutoCompactionSnapshot.ScheduleStatus.NOT_ENABLED).build();
        }
        AutoCompactionSnapshot snapshot = this.datasourceToCompactionSnapshot.get().get(dataSource);
        if (snapshot == null) {
            AutoCompactionSnapshot.ScheduleStatus status = this.isEnabled() ? AutoCompactionSnapshot.ScheduleStatus.AWAITING_FIRST_RUN : AutoCompactionSnapshot.ScheduleStatus.NOT_ENABLED;
            return AutoCompactionSnapshot.builder((String)dataSource).withStatus(status).build();
        }
        return snapshot;
    }

    @Override
    public Map<String, AutoCompactionSnapshot> getAllCompactionSnapshots() {
        return Map.copyOf(this.datasourceToCompactionSnapshot.get());
    }

    @Override
    public CompactionSimulateResult simulateRunWithConfigUpdate(ClusterCompactionConfig updateRequest) {
        if (this.isRunning()) {
            return new CompactionRunSimulator(this.statusTracker, (OverlordClient)this.overlordClient).simulateRunWithConfig(this.getLatestConfig().withClusterConfig(updateRequest), this.getDatasourceSnapshot(), updateRequest.getEngine());
        }
        return new CompactionSimulateResult(Collections.emptyMap());
    }

    private void emitStat(CoordinatorStat stat, RowKey rowKey, long value) {
        if (!stat.shouldEmit()) {
            return;
        }
        ServiceMetricEvent.Builder eventBuilder = new ServiceMetricEvent.Builder();
        rowKey.getValues().forEach((dim, dimValue) -> eventBuilder.setDimension(dim.reportedName(), dimValue));
        this.emitter.emit((ServiceEventBuilder)eventBuilder.setMetric(stat.getMetricName(), (Number)value));
    }

    private DruidCompactionConfig getLatestConfig() {
        List configs = this.activeSupervisors.values().stream().map(s -> s.getSpec().getSpec()).collect(Collectors.toList());
        return DruidCompactionConfig.empty().withClusterConfig(this.getLatestClusterConfig()).withDatasourceConfigs(configs);
    }

    private ClusterCompactionConfig getLatestClusterConfig() {
        return ((DruidCompactionConfig)this.compactionConfigSupplier.get()).clusterConfig();
    }

    private DataSourcesSnapshot getDatasourceSnapshot() {
        return this.segmentManager.getRecentDataSourcesSnapshot();
    }

    private void scheduleOnExecutor(Runnable runnable, long delayMillis) {
        this.executor.schedule(() -> {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                log.error(t, "Error while executing runnable", new Object[0]);
            }
        }, delayMillis, TimeUnit.MILLISECONDS);
    }
}

