/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import io.netty.handler.timeout.TimeoutException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.apache.druid.guice.annotations.EscalatedGlobal;
import org.apache.druid.indexing.overlord.ImmutableWorkerInfo;
import org.apache.druid.indexing.overlord.TaskMaster;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.apache.druid.indexing.overlord.TaskRunnerUtils;
import org.apache.druid.indexing.overlord.WorkerTaskRunner;
import org.apache.druid.indexing.overlord.hrtr.HttpRemoteTaskRunner;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHolder;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class WorkerTaskRunnerQueryAdapter {
    private static final EmittingLogger log = new EmittingLogger(HttpRemoteTaskRunner.class);
    private final TaskMaster taskMaster;
    private final HttpClient httpClient;

    @Inject
    public WorkerTaskRunnerQueryAdapter(TaskMaster taskMaster, @EscalatedGlobal HttpClient httpClient) {
        this.taskMaster = taskMaster;
        this.httpClient = httpClient;
    }

    public void enableWorker(String host) {
        this.sendRequestToWorker(host, WorkerTaskRunner.ActionType.ENABLE);
    }

    public void disableWorker(String host) {
        this.sendRequestToWorker(host, WorkerTaskRunner.ActionType.DISABLE);
    }

    private void sendRequestToWorker(String workerHost, WorkerTaskRunner.ActionType action) {
        WorkerTaskRunner workerTaskRunner = this.getWorkerTaskRunner();
        if (workerTaskRunner == null) {
            throw new RE("Task Runner does not support enable/disable worker actions", new Object[0]);
        }
        Optional workerInfo = Iterables.tryFind(workerTaskRunner.getWorkers(), entry -> entry.getWorker().getHost().equals(workerHost));
        if (!workerInfo.isPresent()) {
            throw new RE("Worker on host %s does not exists", new Object[]{workerHost});
        }
        String actionName = WorkerTaskRunner.ActionType.ENABLE.equals((Object)action) ? "enable" : "disable";
        URL workerUrl = TaskRunnerUtils.makeWorkerURL(((ImmutableWorkerInfo)workerInfo.get()).getWorker(), "/druid/worker/v1/%s", actionName);
        try {
            StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, workerUrl), (HttpResponseHandler)StatusResponseHandler.getInstance()).get();
            log.info("Sent %s action request to worker: %s, status: %s, response: %s", new Object[]{action, workerHost, response.getStatus(), response.getContent()});
            if (!HttpResponseStatus.OK.equals((Object)response.getStatus())) {
                throw new RE("Action [%s] failed for worker [%s] with status %s(%s)", new Object[]{action, workerHost, response.getStatus().getCode(), response.getStatus().getReasonPhrase()});
            }
        }
        catch (TimeoutException | InterruptedException | ExecutionException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    private WorkerTaskRunner getWorkerTaskRunner() {
        Optional<TaskRunner> taskRunnerOpt = this.taskMaster.getTaskRunner();
        if (taskRunnerOpt.isPresent() && taskRunnerOpt.get() instanceof WorkerTaskRunner) {
            return (WorkerTaskRunner)taskRunnerOpt.get();
        }
        return null;
    }
}

