/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.common.config.Configs;
import org.apache.druid.data.input.impl.ByteEntity;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.appenderator.ActionBasedPublishedSegmentRetriever;
import org.apache.druid.indexing.appenderator.ActionBasedSegmentAllocator;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.LockReleaseAction;
import org.apache.druid.indexing.common.actions.SegmentAllocateAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.actions.TaskLocks;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.AbstractTask;
import org.apache.druid.indexing.common.task.PendingSegmentAllocatingTask;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.seekablestream.SeekableStreamAppenderatorConfig;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskIOConfig;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskRunner;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskTuningConfig;
import org.apache.druid.indexing.seekablestream.common.RecordSupplier;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.query.NoopQueryRunner;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.segment.incremental.ParseExceptionHandler;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.realtime.ChatHandler;
import org.apache.druid.segment.realtime.SegmentGenerationMetrics;
import org.apache.druid.segment.realtime.appenderator.Appenderator;
import org.apache.druid.segment.realtime.appenderator.AppenderatorConfig;
import org.apache.druid.segment.realtime.appenderator.PublishedSegmentRetriever;
import org.apache.druid.segment.realtime.appenderator.SegmentAllocator;
import org.apache.druid.segment.realtime.appenderator.StreamAppenderatorDriver;
import org.apache.druid.segment.realtime.appenderator.TaskDirectory;
import org.apache.druid.timeline.partition.NumberedPartialShardSpec;
import org.apache.druid.timeline.partition.PartialShardSpec;

public abstract class SeekableStreamIndexTask<PartitionIdType, SequenceOffsetType, RecordType extends ByteEntity>
extends AbstractTask
implements ChatHandler,
PendingSegmentAllocatingTask {
    public static final long LOCK_ACQUIRE_TIMEOUT_SECONDS = 15L;
    protected final DataSchema dataSchema;
    protected final SeekableStreamIndexTaskTuningConfig tuningConfig;
    protected final SeekableStreamIndexTaskIOConfig<PartitionIdType, SequenceOffsetType> ioConfig;
    protected final Map<String, Object> context;
    protected final LockGranularity lockGranularityToUse;
    protected final TaskLockType lockTypeToUse;
    protected final String supervisorId;
    private final Supplier<SeekableStreamIndexTaskRunner<PartitionIdType, SequenceOffsetType, ?>> runnerSupplier;

    public SeekableStreamIndexTask(String id, @Nullable String supervisorId, @Nullable TaskResource taskResource, DataSchema dataSchema, SeekableStreamIndexTaskTuningConfig tuningConfig, SeekableStreamIndexTaskIOConfig<PartitionIdType, SequenceOffsetType> ioConfig, @Nullable Map<String, Object> context, @Nullable String groupId) {
        super(id, groupId, taskResource, dataSchema.getDataSource(), context, AbstractTask.IngestionMode.APPEND);
        this.dataSchema = (DataSchema)Preconditions.checkNotNull((Object)dataSchema, (Object)"dataSchema");
        this.tuningConfig = (SeekableStreamIndexTaskTuningConfig)Preconditions.checkNotNull((Object)tuningConfig, (Object)"tuningConfig");
        this.ioConfig = (SeekableStreamIndexTaskIOConfig)Preconditions.checkNotNull(ioConfig, (Object)"ioConfig");
        this.context = context;
        this.runnerSupplier = Suppliers.memoize(this::createTaskRunner);
        this.lockGranularityToUse = this.getContextValue("forceTimeChunkLock", true) != false ? LockGranularity.TIME_CHUNK : LockGranularity.SEGMENT;
        this.lockTypeToUse = TaskLocks.determineLockTypeForAppend(this.getContext());
        this.supervisorId = (String)Preconditions.checkNotNull((Object)((String)Configs.valueOrDefault((Object)supervisorId, (Object)dataSchema.getDataSource())), (Object)"supervisorId");
    }

    protected static String getFormattedGroupId(String supervisorId, String type) {
        return StringUtils.format((String)"%s_%s", (Object[])new Object[]{type, supervisorId});
    }

    @Override
    public int getPriority() {
        return this.getContextValue("priority", 75);
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) {
        return true;
    }

    @JsonProperty
    public DataSchema getDataSchema() {
        return this.dataSchema;
    }

    @JsonProperty
    public String getSupervisorId() {
        return this.supervisorId;
    }

    @JsonProperty
    public SeekableStreamIndexTaskTuningConfig getTuningConfig() {
        return this.tuningConfig;
    }

    @JsonProperty(value="ioConfig")
    public SeekableStreamIndexTaskIOConfig<PartitionIdType, SequenceOffsetType> getIOConfig() {
        return this.ioConfig;
    }

    @Override
    public TaskStatus runTask(TaskToolbox toolbox) {
        this.emitMetric(toolbox.getEmitter(), "ingest/count", 1);
        return this.getRunner().run(toolbox);
    }

    @Override
    public boolean canRestore() {
        return true;
    }

    @Override
    public void stopGracefully(TaskConfig taskConfig) {
        if (taskConfig.isRestoreTasksOnRestart()) {
            this.getRunner().stopGracefully();
        } else {
            this.getRunner().stopForcefully();
        }
    }

    @Override
    public <T> QueryRunner<T> getQueryRunner(Query<T> query) {
        if (this.getRunner().getAppenderator() == null) {
            return new NoopQueryRunner();
        }
        return (queryPlus, responseContext) -> queryPlus.run((QuerySegmentWalker)this.getRunner().getAppenderator(), responseContext);
    }

    @Nullable
    public String getCurrentRunnerStatus() {
        SeekableStreamIndexTaskRunner.Status status = this.getRunner() != null ? this.getRunner().getStatus() : null;
        return status != null ? status.toString() : null;
    }

    @Override
    public ServiceMetricEvent.Builder getMetricBuilder() {
        return super.getMetricBuilder().setDimensionIfNotNull("supervisorId", (Object)this.supervisorId);
    }

    public Appenderator newAppenderator(TaskToolbox toolbox, SegmentGenerationMetrics metrics, RowIngestionMeters rowIngestionMeters, ParseExceptionHandler parseExceptionHandler) {
        return toolbox.getAppenderatorsManager().createRealtimeAppenderatorForTask(toolbox.getSegmentLoaderConfig(), this.getId(), this.dataSchema, (AppenderatorConfig)SeekableStreamAppenderatorConfig.fromTuningConfig(this.tuningConfig.withBasePersistDirectory(toolbox.getPersistDir()), toolbox.getProcessingConfig()), (TaskDirectory)toolbox.getConfig(), metrics, toolbox.getSegmentPusher(), toolbox.getJsonMapper(), toolbox.getIndexIO(), toolbox.getIndexMerger(), toolbox.getQueryRunnerFactoryConglomerate(), toolbox.getSegmentAnnouncer(), toolbox.getEmitter(), toolbox.getQueryProcessingPool(), toolbox.getJoinableFactory(), toolbox.getCache(), toolbox.getCacheConfig(), toolbox.getCachePopulatorStats(), toolbox.getPolicyEnforcer(), rowIngestionMeters, parseExceptionHandler, toolbox.getCentralizedTableSchemaConfig(), interval -> toolbox.getTaskActionClient().submit(new LockReleaseAction(interval)));
    }

    public StreamAppenderatorDriver newDriver(Appenderator appenderator, TaskToolbox toolbox, SegmentGenerationMetrics metrics) {
        return new StreamAppenderatorDriver(appenderator, (SegmentAllocator)new ActionBasedSegmentAllocator(toolbox.getTaskActionClient(), this.dataSchema, (schema, row, sequenceName, previousSegmentId, skipSegmentLineageCheck) -> new SegmentAllocateAction(schema.getDataSource(), row.getTimestamp(), schema.getGranularitySpec().getQueryGranularity(), schema.getGranularitySpec().getSegmentGranularity(), sequenceName, previousSegmentId, skipSegmentLineageCheck, (PartialShardSpec)NumberedPartialShardSpec.instance(), this.lockGranularityToUse, this.lockTypeToUse)), toolbox.getSegmentHandoffNotifierFactory(), (PublishedSegmentRetriever)new ActionBasedPublishedSegmentRetriever(toolbox.getTaskActionClient()), toolbox.getDataSegmentKiller(), toolbox.getJsonMapper(), metrics);
    }

    @Override
    public String getTaskAllocatorId() {
        return this.getTaskResource().getAvailabilityGroup();
    }

    protected abstract SeekableStreamIndexTaskRunner<PartitionIdType, SequenceOffsetType, RecordType> createTaskRunner();

    @Deprecated
    protected RecordSupplier<PartitionIdType, SequenceOffsetType, RecordType> newTaskRecordSupplier() {
        throw new UnsupportedOperationException();
    }

    protected RecordSupplier<PartitionIdType, SequenceOffsetType, RecordType> newTaskRecordSupplier(TaskToolbox toolbox) {
        return this.newTaskRecordSupplier();
    }

    @VisibleForTesting
    public Appenderator getAppenderator() {
        return this.getRunner().getAppenderator();
    }

    @VisibleForTesting
    public SeekableStreamIndexTaskRunner<PartitionIdType, SequenceOffsetType, ?> getRunner() {
        return (SeekableStreamIndexTaskRunner)this.runnerSupplier.get();
    }
}

