/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream.supervisor;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.indexing.overlord.supervisor.SupervisorStateManager;
import org.apache.druid.indexing.seekablestream.supervisor.TaskReportData;
import org.apache.druid.java.util.common.IAE;
import org.joda.time.DateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class SeekableStreamSupervisorReportPayload<PartitionIdType, SequenceOffsetType> {
    private final String id;
    private final String dataSource;
    private final String stream;
    private final int partitions;
    private final int replicas;
    private final long durationSeconds;
    private final List<TaskReportData> activeTasks;
    private final List<TaskReportData> publishingTasks;
    private final Map<PartitionIdType, SequenceOffsetType> latestOffsets;
    private final Map<PartitionIdType, Long> minimumLag;
    private final Long aggregateLag;
    private final Map<PartitionIdType, Long> minimumLagMillis;
    private final Long aggregateLagMillis;
    private final DateTime offsetsLastUpdated;
    private final boolean suspended;
    private final boolean healthy;
    private final SupervisorStateManager.State state;
    private final SupervisorStateManager.State detailedState;
    private final List<SupervisorStateManager.ExceptionEvent> recentErrors;

    public SeekableStreamSupervisorReportPayload(String id, String dataSource, String stream, int partitions, int replicas, long durationSeconds, @Nullable Map<PartitionIdType, SequenceOffsetType> latestOffsets, @Nullable Map<PartitionIdType, Long> minimumLag, @Nullable Long aggregateLag, @Nullable Map<PartitionIdType, Long> minimumLagMillis, @Nullable Long aggregateLagMillis, @Nullable DateTime offsetsLastUpdated, boolean suspended, boolean healthy, SupervisorStateManager.State state, SupervisorStateManager.State detailedState, List<SupervisorStateManager.ExceptionEvent> recentErrors) {
        this.id = id;
        this.dataSource = dataSource;
        this.stream = stream;
        this.partitions = partitions;
        this.replicas = replicas;
        this.durationSeconds = durationSeconds;
        this.activeTasks = new ArrayList<TaskReportData>();
        this.publishingTasks = new ArrayList<TaskReportData>();
        this.latestOffsets = latestOffsets;
        this.minimumLag = minimumLag;
        this.aggregateLag = aggregateLag;
        this.minimumLagMillis = minimumLagMillis;
        this.aggregateLagMillis = aggregateLagMillis;
        this.offsetsLastUpdated = offsetsLastUpdated;
        this.suspended = suspended;
        this.healthy = healthy;
        this.state = state;
        this.detailedState = detailedState;
        this.recentErrors = recentErrors;
    }

    public void addTask(TaskReportData data) {
        if (data.getType().equals((Object)TaskReportData.TaskType.ACTIVE)) {
            this.activeTasks.add(data);
        } else if (data.getType().equals((Object)TaskReportData.TaskType.PUBLISHING)) {
            this.publishingTasks.add(data);
        } else {
            throw new IAE("Unknown task type [%s]", new Object[]{data.getType().name()});
        }
    }

    @JsonProperty
    public String getId() {
        return this.id;
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public String getStream() {
        return this.stream;
    }

    @JsonProperty
    public int getPartitions() {
        return this.partitions;
    }

    @JsonProperty
    public int getReplicas() {
        return this.replicas;
    }

    @JsonProperty
    public boolean isSuspended() {
        return this.suspended;
    }

    @JsonProperty
    public boolean isHealthy() {
        return this.healthy;
    }

    @JsonProperty
    public long getDurationSeconds() {
        return this.durationSeconds;
    }

    @JsonProperty
    public List<? extends TaskReportData> getActiveTasks() {
        return this.activeTasks;
    }

    @JsonProperty
    public List<? extends TaskReportData> getPublishingTasks() {
        return this.publishingTasks;
    }

    @JsonProperty
    public Map<PartitionIdType, SequenceOffsetType> getLatestOffsets() {
        return this.latestOffsets;
    }

    @JsonProperty
    public Map<PartitionIdType, Long> getMinimumLag() {
        return this.minimumLag;
    }

    @JsonProperty
    public Long getAggregateLag() {
        return this.aggregateLag;
    }

    @JsonProperty
    public Long getAggregateLagMillis() {
        return this.aggregateLagMillis;
    }

    @JsonProperty
    public Map<PartitionIdType, Long> getMinimumLagMillis() {
        return this.minimumLagMillis;
    }

    @JsonProperty
    public DateTime getOffsetsLastUpdated() {
        return this.offsetsLastUpdated;
    }

    @JsonProperty
    public SupervisorStateManager.State getState() {
        return this.state;
    }

    @JsonProperty
    public SupervisorStateManager.State getDetailedState() {
        return this.detailedState;
    }

    @JsonProperty
    public List<SupervisorStateManager.ExceptionEvent> getRecentErrors() {
        return this.recentErrors;
    }
}

