/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream.supervisor.autoscaler;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.common.config.Configs;
import org.apache.druid.indexing.overlord.supervisor.Supervisor;
import org.apache.druid.indexing.overlord.supervisor.SupervisorSpec;
import org.apache.druid.indexing.overlord.supervisor.autoscaler.SupervisorTaskAutoScaler;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisor;
import org.apache.druid.indexing.seekablestream.supervisor.autoscaler.AutoScalerConfig;
import org.apache.druid.indexing.seekablestream.supervisor.autoscaler.CostBasedAutoScaler;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CostBasedAutoScalerConfig
implements AutoScalerConfig {
    private static final long DEFAULT_SCALE_ACTION_PERIOD_MILLIS = 900000L;
    private static final long DEFAULT_MIN_TRIGGER_SCALE_ACTION_FREQUENCY_MILLIS = 1200000L;
    private static final double DEFAULT_LAG_WEIGHT = 0.25;
    private static final double DEFAULT_IDLE_WEIGHT = 0.75;
    private static final double DEFAULT_PROCESSING_RATE = 1000.0;
    private final boolean enableTaskAutoScaler;
    private final int taskCountMax;
    private final int taskCountMin;
    private final Integer taskCountStart;
    private final long minTriggerScaleActionFrequencyMillis;
    private final Double stopTaskCountRatio;
    private final long scaleActionPeriodMillis;
    private final double lagWeight;
    private final double idleWeight;
    private final double defaultProcessingRate;

    @JsonCreator
    public CostBasedAutoScalerConfig(@JsonProperty(value="taskCountMax") Integer taskCountMax, @JsonProperty(value="taskCountMin") Integer taskCountMin, @Nullable @JsonProperty(value="enableTaskAutoScaler") Boolean enableTaskAutoScaler, @Nullable @JsonProperty(value="taskCountStart") Integer taskCountStart, @Nullable @JsonProperty(value="minTriggerScaleActionFrequencyMillis") Long minTriggerScaleActionFrequencyMillis, @Nullable @JsonProperty(value="stopTaskCountRatio") Double stopTaskCountRatio, @Nullable @JsonProperty(value="scaleActionPeriodMillis") Long scaleActionPeriodMillis, @Nullable @JsonProperty(value="lagWeight") Double lagWeight, @Nullable @JsonProperty(value="idleWeight") Double idleWeight, @Nullable @JsonProperty(value="defaultProcessingRate") Double defaultProcessingRate) {
        this.enableTaskAutoScaler = enableTaskAutoScaler != null ? enableTaskAutoScaler : false;
        this.scaleActionPeriodMillis = scaleActionPeriodMillis != null ? scaleActionPeriodMillis : 900000L;
        this.minTriggerScaleActionFrequencyMillis = Configs.valueOrDefault((Long)minTriggerScaleActionFrequencyMillis, (long)1200000L);
        this.lagWeight = (Double)Configs.valueOrDefault((Object)lagWeight, (Object)0.25);
        this.idleWeight = (Double)Configs.valueOrDefault((Object)idleWeight, (Object)0.75);
        this.defaultProcessingRate = (Double)Configs.valueOrDefault((Object)defaultProcessingRate, (Object)1000.0);
        if (this.enableTaskAutoScaler) {
            Preconditions.checkNotNull((Object)taskCountMax, (Object)"taskCountMax is required when enableTaskAutoScaler is true");
            Preconditions.checkNotNull((Object)taskCountMin, (Object)"taskCountMin is required when enableTaskAutoScaler is true");
            Preconditions.checkArgument((taskCountMax >= taskCountMin ? 1 : 0) != 0, (Object)"taskCountMax must be >= taskCountMin");
            Preconditions.checkArgument((taskCountStart == null || taskCountStart >= taskCountMin && taskCountStart <= taskCountMax ? 1 : 0) != 0, (Object)"taskCountMin <= taskCountStart <= taskCountMax");
            this.taskCountMax = taskCountMax;
            this.taskCountMin = taskCountMin;
        } else {
            this.taskCountMax = Configs.valueOrDefault((Integer)taskCountMax, (int)0);
            this.taskCountMin = Configs.valueOrDefault((Integer)taskCountMin, (int)0);
        }
        this.taskCountStart = taskCountStart;
        Preconditions.checkArgument((stopTaskCountRatio == null || stopTaskCountRatio > 0.0 && stopTaskCountRatio <= 1.0 ? 1 : 0) != 0, (Object)"0.0 < stopTaskCountRatio <= 1.0");
        this.stopTaskCountRatio = stopTaskCountRatio;
        Preconditions.checkArgument((this.lagWeight >= 0.0 ? 1 : 0) != 0, (Object)"lagWeight must be >= 0");
        Preconditions.checkArgument((this.idleWeight >= 0.0 ? 1 : 0) != 0, (Object)"idleWeight must be >= 0");
        Preconditions.checkArgument((this.defaultProcessingRate > 0.0 ? 1 : 0) != 0, (Object)"defaultProcessingRate must be > 0");
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    @JsonProperty
    public boolean getEnableTaskAutoScaler() {
        return this.enableTaskAutoScaler;
    }

    @Override
    @JsonProperty
    public int getTaskCountMax() {
        return this.taskCountMax;
    }

    @Override
    @JsonProperty
    public int getTaskCountMin() {
        return this.taskCountMin;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer getTaskCountStart() {
        return this.taskCountStart;
    }

    @Override
    @JsonProperty
    public long getMinTriggerScaleActionFrequencyMillis() {
        return this.minTriggerScaleActionFrequencyMillis;
    }

    @Override
    @JsonProperty
    @Nullable
    public Double getStopTaskCountRatio() {
        return this.stopTaskCountRatio;
    }

    @JsonProperty
    public long getScaleActionPeriodMillis() {
        return this.scaleActionPeriodMillis;
    }

    @JsonProperty
    public double getLagWeight() {
        return this.lagWeight;
    }

    @JsonProperty
    public double getIdleWeight() {
        return this.idleWeight;
    }

    @JsonProperty
    public double getDefaultProcessingRate() {
        return this.defaultProcessingRate;
    }

    @Override
    public SupervisorTaskAutoScaler createAutoScaler(Supervisor supervisor, SupervisorSpec spec, ServiceEmitter emitter) {
        return new CostBasedAutoScaler((SeekableStreamSupervisor)supervisor, this, spec, emitter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CostBasedAutoScalerConfig that = (CostBasedAutoScalerConfig)o;
        return this.enableTaskAutoScaler == that.enableTaskAutoScaler && this.taskCountMax == that.taskCountMax && this.taskCountMin == that.taskCountMin && this.minTriggerScaleActionFrequencyMillis == that.minTriggerScaleActionFrequencyMillis && this.scaleActionPeriodMillis == that.scaleActionPeriodMillis && Double.compare(that.lagWeight, this.lagWeight) == 0 && Double.compare(that.idleWeight, this.idleWeight) == 0 && Double.compare(that.defaultProcessingRate, this.defaultProcessingRate) == 0 && Objects.equals(this.taskCountStart, that.taskCountStart) && Objects.equals(this.stopTaskCountRatio, that.stopTaskCountRatio);
    }

    public int hashCode() {
        return Objects.hash(this.enableTaskAutoScaler, this.taskCountMax, this.taskCountMin, this.taskCountStart, this.minTriggerScaleActionFrequencyMillis, this.stopTaskCountRatio, this.scaleActionPeriodMillis, this.lagWeight, this.idleWeight, this.defaultProcessingRate);
    }

    public String toString() {
        return "CostBasedAutoScalerConfig{enableTaskAutoScaler=" + this.enableTaskAutoScaler + ", taskCountMax=" + this.taskCountMax + ", taskCountMin=" + this.taskCountMin + ", taskCountStart=" + this.taskCountStart + ", minTriggerScaleActionFrequencyMillis=" + this.minTriggerScaleActionFrequencyMillis + ", stopTaskCountRatio=" + this.stopTaskCountRatio + ", scaleActionPeriodMillis=" + this.scaleActionPeriodMillis + ", lagWeight=" + this.lagWeight + ", idleWeight=" + this.idleWeight + ", defaultProcessingRate=" + this.defaultProcessingRate + "}";
    }

    public static class Builder {
        private Integer taskCountMax;
        private Integer taskCountMin;
        private Boolean enableTaskAutoScaler = true;
        private Integer taskCountStart;
        private Long minTriggerScaleActionFrequencyMillis;
        private Double stopTaskCountRatio;
        private Long scaleActionPeriodMillis;
        private Double lagWeight;
        private Double idleWeight;
        private Double defaultProcessingRate;

        private Builder() {
        }

        public Builder taskCountMax(int taskCountMax) {
            this.taskCountMax = taskCountMax;
            return this;
        }

        public Builder taskCountMin(int taskCountMin) {
            this.taskCountMin = taskCountMin;
            return this;
        }

        public Builder enableTaskAutoScaler(boolean enableTaskAutoScaler) {
            this.enableTaskAutoScaler = enableTaskAutoScaler;
            return this;
        }

        public Builder taskCountStart(Integer taskCountStart) {
            this.taskCountStart = taskCountStart;
            return this;
        }

        public Builder minTriggerScaleActionFrequencyMillis(long minTriggerScaleActionFrequencyMillis) {
            this.minTriggerScaleActionFrequencyMillis = minTriggerScaleActionFrequencyMillis;
            return this;
        }

        public Builder stopTaskCountRatio(Double stopTaskCountRatio) {
            this.stopTaskCountRatio = stopTaskCountRatio;
            return this;
        }

        public Builder scaleActionPeriodMillis(long scaleActionPeriodMillis) {
            this.scaleActionPeriodMillis = scaleActionPeriodMillis;
            return this;
        }

        public Builder lagWeight(double lagWeight) {
            this.lagWeight = lagWeight;
            return this;
        }

        public Builder idleWeight(double idleWeight) {
            this.idleWeight = idleWeight;
            return this;
        }

        public Builder defaultProcessingRate(double defaultProcessingRate) {
            this.defaultProcessingRate = defaultProcessingRate;
            return this;
        }

        public CostBasedAutoScalerConfig build() {
            return new CostBasedAutoScalerConfig(this.taskCountMax, this.taskCountMin, this.enableTaskAutoScaler, this.taskCountStart, this.minTriggerScaleActionFrequencyMillis, this.stopTaskCountRatio, this.scaleActionPeriodMillis, this.lagWeight, this.idleWeight, this.defaultProcessingRate);
        }
    }
}

