/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream.supervisor.autoscaler;

import org.apache.druid.indexing.seekablestream.supervisor.autoscaler.CostBasedAutoScalerConfig;
import org.apache.druid.indexing.seekablestream.supervisor.autoscaler.CostMetrics;
import org.apache.druid.indexing.seekablestream.supervisor.autoscaler.CostResult;
import org.apache.druid.java.util.common.logger.Logger;

public class WeightedCostFunction {
    private static final Logger log = new Logger(WeightedCostFunction.class);
    static final double IDEAL_IDLE_MIN = 0.2;
    static final double IDEAL_IDLE_MAX = 0.6;

    public static boolean isIdleInIdealRange(double idleRatio) {
        return idleRatio >= 0.2 && idleRatio <= 0.6;
    }

    public CostResult computeCost(CostMetrics metrics, int proposedTaskCount, CostBasedAutoScalerConfig config) {
        if (metrics == null || config == null || proposedTaskCount <= 0 || metrics.getPartitionCount() <= 0) {
            return new CostResult(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        double avgProcessingRate = metrics.getAvgProcessingRate();
        if (avgProcessingRate <= 0.0) {
            if (proposedTaskCount == metrics.getCurrentTaskCount()) {
                return new CostResult(0.01, 0.0, 0.0);
            }
            return new CostResult(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        double lagRecoveryTime = metrics.getAggregateLag() / ((double)proposedTaskCount * avgProcessingRate);
        double predictedIdleRatio = this.estimateIdleRatio(metrics, proposedTaskCount);
        double idleCost = (double)((long)proposedTaskCount * metrics.getTaskDurationSeconds()) * predictedIdleRatio;
        double lagCost = config.getLagWeight() * lagRecoveryTime;
        double weightedIdleCost = config.getIdleWeight() * idleCost;
        double cost = lagCost + weightedIdleCost;
        log.debug("Cost for taskCount[%d]: lagCost[%.2fs], idleCost[%.2fs], predictedIdle[%.3f], finalCost[%.2fs]", new Object[]{proposedTaskCount, lagCost, weightedIdleCost, predictedIdleRatio, cost});
        return new CostResult(cost, lagCost, weightedIdleCost);
    }

    private double estimateIdleRatio(CostMetrics metrics, int taskCount) {
        double currentPollIdleRatio = metrics.getPollIdleRatio();
        if (currentPollIdleRatio < 0.0) {
            return 0.5;
        }
        int currentTaskCount = metrics.getCurrentTaskCount();
        if (currentTaskCount <= 0 || taskCount == currentTaskCount) {
            return currentPollIdleRatio;
        }
        double busyFraction = 1.0 - currentPollIdleRatio;
        double taskRatio = (double)taskCount / (double)currentTaskCount;
        double predictedIdleRatio = 1.0 - busyFraction / taskRatio;
        return Math.max(0.0, Math.min(1.0, predictedIdleRatio));
    }
}

