/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.worker.shuffle;

import com.google.common.io.ByteSource;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.io.IOException;
import java.util.Optional;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.druid.indexing.worker.shuffle.IntermediaryDataManager;
import org.apache.druid.indexing.worker.shuffle.ShuffleMetrics;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.http.security.StateResourceFilter;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

@Path(value="/druid/worker/v1/shuffle")
@ResourceFilters(value={StateResourceFilter.class})
public class ShuffleResource {
    private static final Logger log = new Logger(ShuffleResource.class);
    private final IntermediaryDataManager intermediaryDataManager;
    private final Optional<ShuffleMetrics> shuffleMetrics;

    @Inject
    public ShuffleResource(IntermediaryDataManager intermediaryDataManager, Optional<ShuffleMetrics> shuffleMetrics) {
        this.intermediaryDataManager = intermediaryDataManager;
        this.shuffleMetrics = shuffleMetrics;
    }

    @GET
    @Path(value="/task/{supervisorTaskId}/{subTaskId}/partition")
    @Produces(value={"application/octet-stream"})
    public Response getPartition(@PathParam(value="supervisorTaskId") String supervisorTaskId, @PathParam(value="subTaskId") String subTaskId, @QueryParam(value="startTime") String startTime, @QueryParam(value="endTime") String endTime, @QueryParam(value="bucketId") int bucketId) {
        Interval interval = new Interval((ReadableInstant)DateTimes.of((String)startTime), (ReadableInstant)DateTimes.of((String)endTime));
        Optional<ByteSource> partitionFile = this.intermediaryDataManager.findPartitionFile(supervisorTaskId, subTaskId, interval, bucketId);
        if (!partitionFile.isPresent()) {
            String errorMessage = StringUtils.format((String)"Can't find the partition for supervisorTask[%s], subTask[%s], interval[%s], and bucketId[%s]", (Object[])new Object[]{supervisorTaskId, subTaskId, interval, bucketId});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errorMessage).build();
        }
        try {
            long size = partitionFile.get().size();
            this.shuffleMetrics.ifPresent(metrics -> metrics.shuffleRequested(supervisorTaskId, size));
        }
        catch (IOException ioException) {
            log.error("Failed to get length of file for supervisorTask[%s], subTask[%s], interval[%s], and bucketId[%s]", new Object[]{supervisorTaskId, subTaskId, interval, bucketId});
        }
        return Response.ok(output -> ((ByteSource)partitionFile.get()).copyTo(output)).build();
    }

    @DELETE
    @Path(value="/task/{supervisorTaskId}")
    public Response deletePartitions(@PathParam(value="supervisorTaskId") String supervisorTaskId) {
        try {
            this.intermediaryDataManager.deletePartitions(supervisorTaskId);
            return Response.ok((Object)supervisorTaskId).build();
        }
        catch (IOException e) {
            log.error((Throwable)e, "Error while deleting partitions of supervisorTask[%s]", new Object[]{supervisorTaskId});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }
}

