/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;

class BooleanArgument
implements Argument {
    private final Boolean value;

    BooleanArgument(Boolean value) {
        this.value = value;
    }

    @Override
    public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
        if (this.value == null) {
            statement.setNull(position, 16);
        } else {
            statement.setBoolean(position, this.value);
        }
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

