/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.NeuronDeviceInfo;
import com.amazonaws.services.ec2.model.NeuronInfo;
import com.amazonaws.services.ec2.model.transform.NeuronDeviceInfoStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class NeuronInfoStaxUnmarshaller
implements Unmarshaller<NeuronInfo, StaxUnmarshallerContext> {
    private static NeuronInfoStaxUnmarshaller instance;

    public NeuronInfo unmarshall(StaxUnmarshallerContext context) throws Exception {
        NeuronInfo neuronInfo = new NeuronInfo();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return neuronInfo;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("neuronDevices", targetDepth)) {
                    neuronInfo.withNeuronDevices(new ArrayList<NeuronDeviceInfo>());
                    continue;
                }
                if (context.testExpression("neuronDevices/item", targetDepth)) {
                    neuronInfo.withNeuronDevices(NeuronDeviceInfoStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("totalNeuronDeviceMemoryInMiB", targetDepth)) continue;
                neuronInfo.setTotalNeuronDeviceMemoryInMiB(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return neuronInfo;
    }

    public static NeuronInfoStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new NeuronInfoStaxUnmarshaller();
        }
        return instance;
    }
}

