/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord.common;

import com.google.common.base.Optional;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.kubernetes.client.informers.cache.Store;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.Stopwatch;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.k8s.overlord.common.DruidKubernetesCachingClient;
import org.apache.druid.k8s.overlord.common.JobResponse;
import org.apache.druid.k8s.overlord.common.K8sTaskId;
import org.apache.druid.k8s.overlord.common.KubernetesPeonClient;
import org.apache.druid.k8s.overlord.common.PeonPhase;
import org.joda.time.Duration;

public class CachingKubernetesPeonClient
extends KubernetesPeonClient {
    protected static final EmittingLogger log = new EmittingLogger(CachingKubernetesPeonClient.class);
    private final DruidKubernetesCachingClient cachingClient;

    public CachingKubernetesPeonClient(DruidKubernetesCachingClient cachingClient, String namespace, String overlordNamespace, boolean debugJobs, ServiceEmitter emitter) {
        super(cachingClient.getBaseClient(), namespace, overlordNamespace == null ? "" : overlordNamespace, debugJobs, emitter);
        this.cachingClient = cachingClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JobResponse waitForPeonJobCompletion(K8sTaskId taskId, long howLong, TimeUnit unit) {
        Duration timeout = Duration.millis((long)unit.toMillis(howLong));
        Duration jobMustBeSeenWithin = Duration.millis((long)(this.cachingClient.getInformerResyncPeriodMillis() * 2L));
        Stopwatch stopwatch = Stopwatch.createStarted();
        boolean jobSeenInCache = false;
        try {
            CompletableFuture<Job> jobFuture = null;
            while (stopwatch.hasNotElapsed(timeout) && (jobSeenInCache || stopwatch.hasNotElapsed(jobMustBeSeenWithin))) {
                Object job;
                Optional<Job> maybeJob;
                if (jobFuture == null || jobFuture.isDone()) {
                    jobFuture = this.cachingClient.waitForJobChange(taskId.getK8sJobName());
                }
                if ((maybeJob = this.getPeonJob(taskId.getK8sJobName())).isPresent()) {
                    jobSeenInCache = true;
                    job = (Job)maybeJob.get();
                    JobResponse currentResponse = this.determineJobResponse((Job)job);
                    if (currentResponse.getPhase() != PeonPhase.RUNNING) {
                        JobResponse jobResponse = currentResponse;
                        return jobResponse;
                    }
                    log.debug("K8s job[%s] found in cache and is still running", new Object[]{taskId.getK8sJobName()});
                } else {
                    if (jobSeenInCache) {
                        log.warn("K8s Job[%s] was not found. It can happen if the task was canceled", new Object[]{taskId.getK8sJobName()});
                        job = new JobResponse(null, PeonPhase.FAILED);
                        return job;
                    }
                    log.debug("K8s job[%s] not yet found in cache", new Object[]{taskId.getK8sJobName()});
                }
                try {
                    jobFuture.get(this.cachingClient.getInformerResyncPeriodMillis(), TimeUnit.MILLISECONDS);
                }
                catch (CancellationException | ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof CancellationException) {
                        log.noStackTrace().warn("Job change watch for job[%s] was cancelled", new Object[]{taskId.getK8sJobName()});
                        continue;
                    }
                    log.noStackTrace().warn(cause, "Exception while waiting for change notification of job[%s]", new Object[]{taskId.getK8sJobName()});
                }
                catch (TimeoutException e) {
                    log.debug("Timeout waiting for change notification of job[%s].", new Object[]{taskId.getK8sJobName()});
                }
                catch (InterruptedException e) {
                    throw DruidException.defensive((Throwable)e, (String)"Interrupted waiting for job change notification for job[%s]", (Object[])new Object[]{taskId.getK8sJobName()});
                }
            }
        }
        finally {
            this.cachingClient.cancelJobWatcher(taskId.getK8sJobName());
        }
        log.warn("Timed out waiting for K8s job[%s] to complete", new Object[]{taskId.getK8sJobName()});
        return new JobResponse(null, PeonPhase.FAILED);
    }

    @Override
    public List<Job> getPeonJobs() {
        if (this.overlordNamespace.isEmpty()) {
            return this.cachingClient.readJobCache(Store::list);
        }
        return this.cachingClient.readJobCache(indexer -> indexer.byIndex("byOverlordNamespace", this.overlordNamespace));
    }

    @Override
    public Optional<Pod> getPeonPod(String jobName) {
        return this.cachingClient.readPodCache(indexer -> {
            List pods = indexer.byIndex("byJobName", jobName);
            return pods.isEmpty() ? Optional.absent() : Optional.of((Object)((Pod)pods.get(0)));
        });
    }

    public Optional<Job> getPeonJob(String jobName) {
        return this.cachingClient.readJobCache(indexer -> {
            List jobs = indexer.byIndex("byJobName", jobName);
            return jobs.isEmpty() ? Optional.absent() : Optional.of((Object)((Job)jobs.get(0)));
        });
    }

    /*
     * Exception decompiling
     */
    @Override
    @Nullable
    protected Pod waitUntilPeonPodCreatedAndReady(String jobName, long howLong, TimeUnit timeUnit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isPodRunningOrComplete(Pod pod) {
        List<String> matchingPhases = List.of("Running", "Succeeded", "Failed");
        return pod.getStatus() != null && pod.getStatus().getPhase() != null && matchingPhases.contains(pod.getStatus().getPhase());
    }

    private JobResponse determineJobResponse(Job job) {
        if (job.getStatus() != null) {
            Integer active = job.getStatus().getActive();
            Integer succeeded = job.getStatus().getSucceeded();
            Integer failed = job.getStatus().getFailed();
            if (!(active != null && active != 0 || succeeded == null && failed == null)) {
                if (succeeded != null && succeeded > 0) {
                    log.info("K8s job[%s] completed successfully", new Object[]{job.getMetadata().getName()});
                    return new JobResponse(job, PeonPhase.SUCCEEDED);
                }
                log.warn("K8s job[%s] failed with status %s", new Object[]{job.getMetadata().getName(), job.getStatus()});
                return new JobResponse(job, PeonPhase.FAILED);
            }
        }
        log.debug("K8s job[%s] is still active.", new Object[]{job.getMetadata().getName()});
        return new JobResponse(job, PeonPhase.RUNNING);
    }
}

