/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord.taskadapter;

import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import io.fabric8.kubernetes.api.model.PodTemplate;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.k8s.overlord.KubernetesTaskRunnerEffectiveConfig;
import org.apache.druid.k8s.overlord.taskadapter.PodTemplateSelector;
import org.apache.druid.k8s.overlord.taskadapter.PodTemplateWithName;

public class DynamicConfigPodTemplateSelector
implements PodTemplateSelector {
    private static final String TASK_PROPERTY = "druid.indexer.runner.k8s.podTemplate.";
    private final Properties properties;
    private final KubernetesTaskRunnerEffectiveConfig effectiveConfig;
    private HashMap<String, Supplier<PodTemplate>> podTemplates;

    public DynamicConfigPodTemplateSelector(Properties properties, KubernetesTaskRunnerEffectiveConfig effectiveConfig) {
        this.properties = properties;
        this.effectiveConfig = effectiveConfig;
        this.initializeTemplatesFromFileSystem();
    }

    private void initializeTemplatesFromFileSystem() throws IAE {
        Set<String> taskAdapterTemplateKeys = this.getTaskAdapterTemplatesKeys(this.properties);
        if (!taskAdapterTemplateKeys.contains("base")) {
            throw new IAE("Pod template task adapter requires a base pod template to be specified under druid.indexer.runner.k8s.podTemplate.base", new Object[0]);
        }
        HashMap<String, Supplier> podTemplateMap = new HashMap<String, Supplier>();
        for (String taskAdapterTemplateKey : taskAdapterTemplateKeys) {
            Supplier templateSupplier = () -> this.loadPodTemplate(taskAdapterTemplateKey, this.properties);
            this.validateTemplateSupplier((Supplier<PodTemplate>)templateSupplier);
            podTemplateMap.put(taskAdapterTemplateKey, templateSupplier);
        }
        this.podTemplates = podTemplateMap;
    }

    private Set<String> getTaskAdapterTemplatesKeys(Properties properties) {
        HashSet<String> taskAdapterTemplates = new HashSet<String>();
        for (String runtimeProperty : properties.stringPropertyNames()) {
            if (!runtimeProperty.startsWith(TASK_PROPERTY)) continue;
            String[] taskAdapterPropertyPaths = runtimeProperty.split("\\.");
            taskAdapterTemplates.add(taskAdapterPropertyPaths[taskAdapterPropertyPaths.length - 1]);
        }
        return taskAdapterTemplates;
    }

    private PodTemplate loadPodTemplate(String key, Properties properties) throws IAE {
        String property = TASK_PROPERTY + key;
        String podTemplateFile = properties.getProperty(property);
        if (podTemplateFile == null) {
            throw new IAE("Pod template file not specified for [%s]", new Object[]{property});
        }
        try {
            Optional maybeTemplate = Optional.of((Object)((PodTemplate)Serialization.unmarshal((InputStream)Files.newInputStream(new File(podTemplateFile).toPath(), new OpenOption[0]), PodTemplate.class)));
            return (PodTemplate)maybeTemplate.get();
        }
        catch (Exception e) {
            throw new IAE((Throwable)e, "Failed to load pod template file for [%s] at [%s]", new Object[]{property, podTemplateFile});
        }
    }

    private void validateTemplateSupplier(Supplier<PodTemplate> templateSupplier) throws IAE {
        templateSupplier.get();
    }

    @Override
    public Optional<PodTemplateWithName> getPodTemplateForTask(Task task) {
        return Optional.of((Object)this.effectiveConfig.getPodTemplateSelectStrategy().getPodTemplateForTask(task, this.podTemplates));
    }
}

