/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.messages.client;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.http.client.response.BytesFullResponseHandler;
import org.apache.druid.messages.MessageBatch;
import org.apache.druid.messages.client.MessageRelayClient;
import org.apache.druid.rpc.RequestBuilder;
import org.apache.druid.rpc.ServiceClient;
import org.jboss.netty.handler.codec.http.HttpMethod;

public class MessageRelayClientImpl<MessageType>
implements MessageRelayClient<MessageType> {
    private final ServiceClient serviceClient;
    private final ObjectMapper smileMapper;
    private final JavaType inMessageBatchType;

    public MessageRelayClientImpl(ServiceClient serviceClient, ObjectMapper smileMapper, Class<MessageType> inMessageClass) {
        this.serviceClient = serviceClient;
        this.smileMapper = smileMapper;
        this.inMessageBatchType = smileMapper.getTypeFactory().constructParametricType(MessageBatch.class, new Class[]{inMessageClass});
    }

    @Override
    public ListenableFuture<MessageBatch<MessageType>> getMessages(String clientHost, long epoch, long startWatermark) {
        String path = StringUtils.format((String)"/outbox/%s/messages?epoch=%d&watermark=%d", (Object[])new Object[]{StringUtils.urlEncode((String)clientHost), epoch, startWatermark});
        ListenableFuture asyncRequest = this.serviceClient.asyncRequest(new RequestBuilder(HttpMethod.GET, path), new BytesFullResponseHandler());
        return FutureUtils.transform(asyncRequest, holder -> {
            if (holder.getResponse().getStatus().getCode() == 204) {
                return new MessageBatch(Collections.emptyList(), epoch, startWatermark);
            }
            return (MessageBatch)JacksonUtils.readValue((ObjectMapper)this.smileMapper, (byte[])holder.getContent(), (JavaType)this.inMessageBatchType);
        });
    }
}

