/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.compaction;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.client.indexing.ClientCompactionTaskQuery;
import org.apache.druid.client.indexing.ClientCompactionTaskQueryTuningConfig;
import org.apache.druid.client.indexing.TaskPayloadResponse;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.indexer.partitions.DimensionRangePartitionsSpec;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.LockFilterPolicy;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.server.compaction.CompactionStatusTracker;
import org.apache.druid.server.coordinator.ClusterCompactionConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.duty.CoordinatorDutyUtils;
import org.joda.time.Interval;

public class CompactionSlotManager {
    public static final String COMPACTION_TASK_TYPE = "compact";
    private static final Logger log = new Logger(CompactionSlotManager.class);
    private final OverlordClient overlordClient;
    private final CompactionStatusTracker statusTracker;
    private final Map<String, List<Interval>> intervalsToSkipCompaction;
    private int numAvailableTaskSlots;

    public CompactionSlotManager(OverlordClient overlordClient, CompactionStatusTracker statusTracker, ClusterCompactionConfig clusterCompactionConfig) {
        this.overlordClient = overlordClient;
        this.statusTracker = statusTracker;
        this.numAvailableTaskSlots = this.getCompactionTaskCapacity(clusterCompactionConfig);
        this.intervalsToSkipCompaction = new HashMap<String, List<Interval>>();
    }

    public int getNumAvailableTaskSlots() {
        return this.numAvailableTaskSlots;
    }

    public Map<String, List<Interval>> getDatasourceIntervalsToSkipCompaction() {
        return this.intervalsToSkipCompaction;
    }

    public void reserveTaskSlots(int numSlotsToReserve) {
        this.numAvailableTaskSlots -= numSlotsToReserve;
    }

    public void reserveTaskSlots(ClientCompactionTaskQuery compactionTaskQuery) {
        this.numAvailableTaskSlots -= CompactionSlotManager.computeSlotsRequiredForTask(compactionTaskQuery);
    }

    public void reserveTaskSlotsForRunningCompactionTasks() {
        for (ClientCompactionTaskQuery task : this.fetchRunningCompactionTasks()) {
            this.reserveTaskSlots(task);
        }
    }

    public List<ClientCompactionTaskQuery> fetchRunningCompactionTasks() {
        List<TaskStatusPlus> compactionTasks = CoordinatorDutyUtils.getStatusOfActiveTasks(this.overlordClient, (Predicate<TaskStatusPlus>)((Predicate)status -> status != null && COMPACTION_TASK_TYPE.equals(status.getType())));
        Set<String> activeTaskIds = compactionTasks.stream().map(TaskStatusPlus::getId).collect(Collectors.toSet());
        this.trackStatusOfCompletedTasks(activeTaskIds);
        ArrayList<ClientCompactionTaskQuery> runningCompactTasks = new ArrayList<ClientCompactionTaskQuery>();
        for (TaskStatusPlus status2 : compactionTasks) {
            TaskPayloadResponse response = (TaskPayloadResponse)FutureUtils.getUnchecked(this.overlordClient.taskPayload(status2.getId()), (boolean)true);
            if (response == null) {
                throw new ISE("Could not find payload for active compaction task[%s]", new Object[]{status2.getId()});
            }
            if (!COMPACTION_TASK_TYPE.equals(response.getPayload().getType())) {
                throw new ISE("Payload of active compaction task[%s] is of invalid type[%s]", new Object[]{status2.getId(), response.getPayload().getType()});
            }
            runningCompactTasks.add((ClientCompactionTaskQuery)response.getPayload());
        }
        return runningCompactTasks;
    }

    public boolean cancelTaskOnlyIfGranularityChanged(ClientCompactionTaskQuery compactionTaskQuery, DataSourceCompactionConfig dataSourceCompactionConfig) {
        if (dataSourceCompactionConfig == null || dataSourceCompactionConfig.getGranularitySpec() == null || compactionTaskQuery.getGranularitySpec() == null) {
            this.skipTaskInterval(compactionTaskQuery);
            this.reserveTaskSlots(compactionTaskQuery);
            return false;
        }
        Granularity configuredSegmentGranularity = dataSourceCompactionConfig.getGranularitySpec().getSegmentGranularity();
        Granularity taskSegmentGranularity = compactionTaskQuery.getGranularitySpec().getSegmentGranularity();
        if (configuredSegmentGranularity == null || configuredSegmentGranularity.equals(taskSegmentGranularity)) {
            this.skipTaskInterval(compactionTaskQuery);
            this.reserveTaskSlots(compactionTaskQuery);
            return false;
        }
        log.info("Cancelling task[%s] as task segmentGranularity[%s] differs from compaction config segmentGranularity[%s].", new Object[]{compactionTaskQuery.getId(), taskSegmentGranularity, configuredSegmentGranularity});
        this.overlordClient.cancelTask(compactionTaskQuery.getId());
        return true;
    }

    public void skipLockedIntervals(List<DataSourceCompactionConfig> compactionConfigs) {
        List<LockFilterPolicy> lockFilterPolicies = compactionConfigs.stream().map(config -> new LockFilterPolicy(config.getDataSource(), config.getTaskPriority(), null, config.getTaskContext())).collect(Collectors.toList());
        HashMap<String, List> datasourceToLockedIntervals = new HashMap<String, List>((Map)FutureUtils.getUnchecked(this.overlordClient.findLockedIntervals(lockFilterPolicies), (boolean)true));
        log.debug("Skipping the following intervals for Compaction as they are currently locked: %s", new Object[]{datasourceToLockedIntervals});
        datasourceToLockedIntervals.forEach((dataSource, intervals) -> this.intervalsToSkipCompaction.computeIfAbsent((String)dataSource, ds -> new ArrayList()).addAll(intervals));
    }

    private void skipTaskInterval(ClientCompactionTaskQuery compactionTask) {
        Interval interval = compactionTask.getIoConfig().getInputSpec().getInterval();
        this.intervalsToSkipCompaction.computeIfAbsent(compactionTask.getDataSource(), k -> new ArrayList()).add(interval);
    }

    private int getCompactionTaskCapacity(ClusterCompactionConfig clusterConfig) {
        int totalWorkerCapacity = CoordinatorDutyUtils.getTotalWorkerCapacity(this.overlordClient);
        int compactionTaskCapacity = Math.min((int)((double)totalWorkerCapacity * clusterConfig.getCompactionTaskSlotRatio()), clusterConfig.getMaxCompactionTaskSlots());
        return Math.max(1, compactionTaskCapacity);
    }

    private void trackStatusOfCompletedTasks(Set<String> activeTaskIds) {
        HashSet<String> finishedTaskIds = new HashSet<String>(this.statusTracker.getSubmittedTaskIds());
        finishedTaskIds.removeAll(activeTaskIds);
        if (finishedTaskIds.isEmpty()) {
            return;
        }
        Map taskStatusMap = (Map)FutureUtils.getUnchecked(this.overlordClient.taskStatuses(finishedTaskIds), (boolean)true);
        for (String taskId : finishedTaskIds) {
            TaskStatus taskStatus = taskStatusMap.getOrDefault(taskId, TaskStatus.success((String)taskId));
            if (!taskStatus.isComplete()) continue;
            this.statusTracker.onTaskFinished(taskId, taskStatus);
        }
    }

    public static int getMaxTaskSlotsForNativeCompactionTask(@Nullable ClientCompactionTaskQueryTuningConfig tuningConfig) {
        if (CompactionSlotManager.isParallelMode(tuningConfig)) {
            Integer maxNumConcurrentSubTasks = tuningConfig.getMaxNumConcurrentSubTasks();
            return (maxNumConcurrentSubTasks == null ? 1 : maxNumConcurrentSubTasks) + 1;
        }
        return 1;
    }

    public static int getMaxTaskSlotsForMSQCompactionTask(@Nullable Map<String, Object> context) {
        return context == null ? 2 : (Integer)context.getOrDefault("maxNumTasks", 2);
    }

    @VisibleForTesting
    public static boolean isParallelMode(@Nullable ClientCompactionTaskQueryTuningConfig tuningConfig) {
        if (null == tuningConfig) {
            return false;
        }
        boolean useRangePartitions = CompactionSlotManager.useRangePartitions(tuningConfig);
        int minRequiredNumConcurrentSubTasks = useRangePartitions ? 1 : 2;
        return tuningConfig.getMaxNumConcurrentSubTasks() != null && tuningConfig.getMaxNumConcurrentSubTasks() >= minRequiredNumConcurrentSubTasks;
    }

    private static boolean useRangePartitions(ClientCompactionTaskQueryTuningConfig tuningConfig) {
        return tuningConfig.getPartitionsSpec() instanceof DimensionRangePartitionsSpec;
    }

    public int computeSlotsRequiredForTask(ClientCompactionTaskQuery task, DataSourceCompactionConfig config) {
        if (task.isMsq()) {
            Map<String, Object> autoCompactionContext = task.getContext();
            if (autoCompactionContext.containsKey("maxNumTasks")) {
                return (Integer)autoCompactionContext.get("maxNumTasks");
            }
            int slotsRequiredForCurrentTask = Math.min(this.numAvailableTaskSlots == 1 ? 2 : this.numAvailableTaskSlots, 5);
            autoCompactionContext.put("maxNumTasks", slotsRequiredForCurrentTask);
            return slotsRequiredForCurrentTask;
        }
        return CompactionSlotManager.getMaxTaskSlotsForNativeCompactionTask(config.getTuningConfig());
    }

    public static int computeSlotsRequiredForTask(ClientCompactionTaskQuery task) {
        if (task.isMsq()) {
            return CompactionSlotManager.getMaxTaskSlotsForMSQCompactionTask(task.getContext());
        }
        return CompactionSlotManager.getMaxTaskSlotsForNativeCompactionTask(task.getTuningConfig());
    }
}

