/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.server.compaction.CompactionStatistics;

public class AutoCompactionSnapshot {
    @JsonProperty
    private final String dataSource;
    @JsonProperty
    private final ScheduleStatus scheduleStatus;
    @JsonProperty
    private final String message;
    @JsonProperty
    private final long bytesAwaitingCompaction;
    @JsonProperty
    private final long bytesCompacted;
    @JsonProperty
    private final long bytesSkipped;
    @JsonProperty
    private final long segmentCountAwaitingCompaction;
    @JsonProperty
    private final long segmentCountCompacted;
    @JsonProperty
    private final long segmentCountSkipped;
    @JsonProperty
    private final long intervalCountAwaitingCompaction;
    @JsonProperty
    private final long intervalCountCompacted;
    @JsonProperty
    private final long intervalCountSkipped;

    public static Builder builder(String dataSource) {
        return new Builder(dataSource).withStatus(ScheduleStatus.RUNNING);
    }

    @JsonCreator
    public AutoCompactionSnapshot(@JsonProperty(value="dataSource") @NotNull String dataSource, @JsonProperty(value="scheduleStatus") @NotNull ScheduleStatus scheduleStatus, @JsonProperty(value="message") @Nullable String message, @JsonProperty(value="bytesAwaitingCompaction") long bytesAwaitingCompaction, @JsonProperty(value="bytesCompacted") long bytesCompacted, @JsonProperty(value="bytesSkipped") long bytesSkipped, @JsonProperty(value="segmentCountAwaitingCompaction") long segmentCountAwaitingCompaction, @JsonProperty(value="segmentCountCompacted") long segmentCountCompacted, @JsonProperty(value="segmentCountSkipped") long segmentCountSkipped, @JsonProperty(value="intervalCountAwaitingCompaction") long intervalCountAwaitingCompaction, @JsonProperty(value="intervalCountCompacted") long intervalCountCompacted, @JsonProperty(value="intervalCountSkipped") long intervalCountSkipped) {
        this.dataSource = dataSource;
        this.scheduleStatus = scheduleStatus;
        this.message = message;
        this.bytesAwaitingCompaction = bytesAwaitingCompaction;
        this.bytesCompacted = bytesCompacted;
        this.bytesSkipped = bytesSkipped;
        this.segmentCountAwaitingCompaction = segmentCountAwaitingCompaction;
        this.segmentCountCompacted = segmentCountCompacted;
        this.segmentCountSkipped = segmentCountSkipped;
        this.intervalCountAwaitingCompaction = intervalCountAwaitingCompaction;
        this.intervalCountCompacted = intervalCountCompacted;
        this.intervalCountSkipped = intervalCountSkipped;
    }

    @NotNull
    public String getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public ScheduleStatus getScheduleStatus() {
        return this.scheduleStatus;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    public long getBytesAwaitingCompaction() {
        return this.bytesAwaitingCompaction;
    }

    public long getBytesCompacted() {
        return this.bytesCompacted;
    }

    public long getBytesSkipped() {
        return this.bytesSkipped;
    }

    public long getSegmentCountAwaitingCompaction() {
        return this.segmentCountAwaitingCompaction;
    }

    public long getSegmentCountCompacted() {
        return this.segmentCountCompacted;
    }

    public long getSegmentCountSkipped() {
        return this.segmentCountSkipped;
    }

    public long getIntervalCountAwaitingCompaction() {
        return this.intervalCountAwaitingCompaction;
    }

    public long getIntervalCountCompacted() {
        return this.intervalCountCompacted;
    }

    public long getIntervalCountSkipped() {
        return this.intervalCountSkipped;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoCompactionSnapshot that = (AutoCompactionSnapshot)o;
        return this.bytesAwaitingCompaction == that.bytesAwaitingCompaction && this.bytesCompacted == that.bytesCompacted && this.bytesSkipped == that.bytesSkipped && this.segmentCountAwaitingCompaction == that.segmentCountAwaitingCompaction && this.segmentCountCompacted == that.segmentCountCompacted && this.segmentCountSkipped == that.segmentCountSkipped && this.intervalCountAwaitingCompaction == that.intervalCountAwaitingCompaction && this.intervalCountCompacted == that.intervalCountCompacted && this.intervalCountSkipped == that.intervalCountSkipped && this.dataSource.equals(that.dataSource) && this.scheduleStatus == that.scheduleStatus && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dataSource, this.scheduleStatus, this.message, this.bytesAwaitingCompaction, this.bytesCompacted, this.bytesSkipped, this.segmentCountAwaitingCompaction, this.segmentCountCompacted, this.segmentCountSkipped, this.intervalCountAwaitingCompaction, this.intervalCountCompacted, this.intervalCountSkipped});
    }

    public String toString() {
        return "AutoCompactionSnapshot{dataSource='" + this.dataSource + "', scheduleStatus=" + String.valueOf((Object)this.scheduleStatus) + ", message='" + this.message + "', bytesAwaitingCompaction=" + this.bytesAwaitingCompaction + ", bytesCompacted=" + this.bytesCompacted + ", bytesSkipped=" + this.bytesSkipped + ", segmentCountAwaitingCompaction=" + this.segmentCountAwaitingCompaction + ", segmentCountCompacted=" + this.segmentCountCompacted + ", segmentCountSkipped=" + this.segmentCountSkipped + ", intervalCountAwaitingCompaction=" + this.intervalCountAwaitingCompaction + ", intervalCountCompacted=" + this.intervalCountCompacted + ", intervalCountSkipped=" + this.intervalCountSkipped + "}";
    }

    public static class Builder {
        private final String dataSource;
        private ScheduleStatus scheduleStatus;
        private String message;
        private final CompactionStatistics compactedStats = new CompactionStatistics();
        private final CompactionStatistics skippedStats = new CompactionStatistics();
        private final CompactionStatistics waitingStats = new CompactionStatistics();

        private Builder(@NotNull String dataSource) {
            if (dataSource == null || dataSource.isEmpty()) {
                throw new ISE("Invalid dataSource name", new Object[0]);
            }
            this.dataSource = dataSource;
        }

        public Builder withStatus(ScheduleStatus status) {
            this.scheduleStatus = (ScheduleStatus)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"scheduleStatus cannot be null"));
            return this;
        }

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public void incrementWaitingStats(CompactionStatistics entry) {
            this.waitingStats.increment(entry);
        }

        public void decrementWaitingStats(CompactionStatistics entry) {
            this.waitingStats.decrement(entry);
        }

        public void incrementCompactedStats(CompactionStatistics entry) {
            this.compactedStats.increment(entry);
        }

        public void incrementSkippedStats(CompactionStatistics entry) {
            this.skippedStats.increment(entry);
        }

        public AutoCompactionSnapshot build() {
            return new AutoCompactionSnapshot(this.dataSource, this.scheduleStatus, this.message, this.waitingStats.getTotalBytes(), this.compactedStats.getTotalBytes(), this.skippedStats.getTotalBytes(), this.waitingStats.getNumSegments(), this.compactedStats.getNumSegments(), this.skippedStats.getNumSegments(), this.waitingStats.getNumIntervals(), this.compactedStats.getNumIntervals(), this.skippedStats.getNumIntervals());
        }
    }

    public static enum ScheduleStatus {
        NOT_ENABLED,
        AWAITING_FIRST_RUN,
        RUNNING;

    }
}

