/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.initialization.jetty;

import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.multibindings.Multibinder;
import java.util.Properties;
import org.apache.druid.guice.Jerseys;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.annotations.RemoteChatHandler;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.metrics.TaskHolder;
import org.apache.druid.segment.realtime.ChatHandlerResource;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.initialization.TLSServerConfig;
import org.apache.druid.server.initialization.jetty.JettyBindings;
import org.apache.druid.server.initialization.jetty.JettyServerModule;
import org.apache.druid.server.initialization.jetty.ServletFilterHolder;
import org.apache.druid.server.initialization.jetty.TaskIdResponseHeaderFilterHolder;
import org.apache.druid.server.security.TLSCertificateChecker;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class ChatHandlerServerModule
implements Module {
    private static final String MAX_CHAT_REQUESTS_PROPERTY = "druid.indexer.server.maxChatRequests";
    private final Properties properties;

    public ChatHandlerServerModule(Properties properties) {
        this.properties = properties;
    }

    public void configure(Binder binder) {
        Jerseys.addResource((Binder)binder, ChatHandlerResource.class);
        LifecycleModule.register((Binder)binder, ChatHandlerResource.class);
        if (this.properties.containsKey(MAX_CHAT_REQUESTS_PROPERTY)) {
            int maxRequests = Integer.parseInt(this.properties.getProperty(MAX_CHAT_REQUESTS_PROPERTY));
            JettyBindings.addQosFilter(binder, "/druid/worker/v1/chat/*", maxRequests);
        }
        Multibinder.newSetBinder((Binder)binder, ServletFilterHolder.class).addBinding().to(TaskIdResponseHeaderFilterHolder.class);
        binder.bind(DruidNode.class).annotatedWith(RemoteChatHandler.class).to(Key.get(DruidNode.class, Self.class));
        binder.bind(ServerConfig.class).annotatedWith(RemoteChatHandler.class).to(Key.get(ServerConfig.class));
        binder.bind(TLSServerConfig.class).annotatedWith(RemoteChatHandler.class).to(Key.get(TLSServerConfig.class));
    }

    @Provides
    @LazySingleton
    public TaskIdResponseHeaderFilterHolder taskIdResponseHeaderFilterHolderBuilder(TaskHolder taskHolder) {
        return new TaskIdResponseHeaderFilterHolder("/druid/worker/v1/chat/*", taskHolder.getTaskId());
    }

    @Provides
    @LazySingleton
    @RemoteChatHandler
    public Server getServer(Injector injector, Lifecycle lifecycle, @RemoteChatHandler DruidNode node, @RemoteChatHandler ServerConfig config, @RemoteChatHandler TLSServerConfig TLSServerConfig2) {
        return JettyServerModule.makeAndInitializeServer(injector, lifecycle, node, config, TLSServerConfig2, (Binding<SslContextFactory.Server>)injector.getExistingBinding(Key.get(SslContextFactory.Server.class)), (TLSCertificateChecker)injector.getInstance(TLSCertificateChecker.class));
    }
}

