/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.kafkainput;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.data.input.kafkainput.KafkaHeaderReader;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;

public class KafkaStringHeaderReader
implements KafkaHeaderReader {
    private static final Logger log = new Logger(KafkaStringHeaderReader.class);
    private final Headers headers;
    private final String headerLabelPrefix;
    private final Charset encoding;

    public KafkaStringHeaderReader(Headers headers, String headerLabelPrefix, Charset encoding) {
        this.headers = headers;
        this.headerLabelPrefix = headerLabelPrefix;
        this.encoding = encoding;
    }

    @Override
    public List<Pair<String, Object>> read() {
        ArrayList<Pair<String, Object>> events = new ArrayList<Pair<String, Object>>();
        for (Header hdr : this.headers) {
            byte[] value = hdr.value();
            String s = value == null ? null : new String(value, this.encoding);
            String newKey = this.headerLabelPrefix + hdr.key();
            events.add((Pair<String, Object>)Pair.of((Object)newKey, (Object)s));
        }
        return events;
    }
}

