/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation.builtin;

import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.SingleValueAggregatorFactory;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.builtin.SimpleSqlAggregator;
import org.apache.druid.sql.calcite.planner.Calcites;

public class SingleValueSqlAggregator
extends SimpleSqlAggregator {
    @Override
    public SqlAggFunction calciteFunction() {
        return SqlStdOperatorTable.SINGLE_VALUE;
    }

    @Override
    @Nullable
    Aggregation getAggregation(String name, AggregateCall aggregateCall, ExprMacroTable macroTable, String fieldName) {
        ColumnType valueType = Calcites.getColumnTypeForRelDataType(aggregateCall.getType());
        if (valueType == null) {
            return null;
        }
        return Aggregation.create(SingleValueSqlAggregator.createSingleValueAggregatorFactory(valueType, name, fieldName));
    }

    static AggregatorFactory createSingleValueAggregatorFactory(ColumnType aggregationType, String name, String fieldName) {
        return new SingleValueAggregatorFactory(name, fieldName, aggregationType);
    }
}

