/*
 * Decompiled with CFR 0.152.
 */
package org.schemarepo.json;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.schemarepo.SchemaEntry;
import org.schemarepo.Subject;
import org.schemarepo.json.JsonUtil;

public class GsonJsonUtil
implements JsonUtil {
    private static final Gson GSON_FOR_SUBJECTS = new GsonBuilder().setPrettyPrinting().serializeNulls().setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return fieldAttributes.getName() != "name";
        }

        public boolean shouldSkipClass(Class<?> aClass) {
            return false;
        }
    }}).create();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type SUBJECT_LIST_TYPE = new TypeToken<List<SubjectRepresentation>>(){}.getType();
    private static final Type SCHEMA_ENTRY_LIST_TYPE = new TypeToken<List<SchemaEntry>>(){}.getType();

    @Override
    public String subjectsToJson(Iterable<Subject> subjects) {
        return GSON_FOR_SUBJECTS.toJson(subjects);
    }

    @Override
    public Iterable<String> subjectNamesFromJson(String str) {
        ArrayList<String> stringList = new ArrayList<String>();
        if (str != null && !str.equals("")) {
            ArrayList subjectList = (ArrayList)GSON_FOR_SUBJECTS.fromJson(str, SUBJECT_LIST_TYPE);
            for (SubjectRepresentation subject : subjectList) {
                stringList.add(subject.getName());
            }
        }
        return stringList;
    }

    @Override
    public String schemasToJson(Iterable<SchemaEntry> allEntries) {
        return GSON.toJson(allEntries);
    }

    @Override
    public Iterable<SchemaEntry> schemasFromJson(String str) {
        if (str == null || str.equals("")) {
            return new ArrayList<SchemaEntry>();
        }
        return (Iterable)GSON.fromJson(str, SCHEMA_ENTRY_LIST_TYPE);
    }

    private class SubjectRepresentation {
        private String name;

        SubjectRepresentation(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

