/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.inputsource.hdfs;

import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.function.Supplier;
import org.apache.druid.data.input.RetryingInputEntity;
import org.apache.druid.storage.hdfs.HdfsDataSegmentPuller;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsInputEntity
extends RetryingInputEntity {
    private final Configuration conf;
    private final Path path;
    private final Supplier<URI> uri;

    HdfsInputEntity(Configuration conf, Path path) {
        this.conf = conf;
        this.path = path;
        this.uri = Suppliers.memoize(() -> {
            URI uri0 = path.toUri();
            if (uri0.getScheme() == null || uri0.getAuthority() == null) {
                try {
                    return path.getFileSystem(conf).makeQualified(path).toUri();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return uri0;
        });
    }

    public URI getUri() {
        return this.uri.get();
    }

    protected InputStream readFrom(long offset) throws IOException {
        FileSystem fs = this.path.getFileSystem(this.conf);
        FSDataInputStream inputStream = fs.open(this.path);
        inputStream.seek(offset);
        return inputStream;
    }

    protected String getPath() {
        return this.getUri().getPath();
    }

    public Predicate<Throwable> getRetryCondition() {
        return HdfsDataSegmentPuller.RETRY_PREDICATE;
    }
}

