/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;

public class StatementInfo {
    private volatile Boolean relativeSupported = null;
    final Statement statement;
    private ResultSet resultSet;
    private long position = 0L;
    private boolean resultsInitialized = false;

    public StatementInfo(Statement statement) {
        this.statement = statement;
    }

    void setPosition(long position) {
        this.position = position;
    }

    long getPosition() {
        return this.position;
    }

    public void setResultSet(ResultSet resultSet) {
        this.resultsInitialized = true;
        this.resultSet = resultSet;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public boolean isResultSetInitialized() {
        return this.resultsInitialized;
    }

    public boolean next() throws SQLException {
        return this._next(this.resultSet);
    }

    boolean _next(ResultSet results) throws SQLException {
        boolean ret = results.next();
        ++this.position;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean advanceResultSetToOffset(ResultSet results, long offset) throws SQLException {
        if (offset < 0L || offset < this.position) {
            throw new IllegalArgumentException("Offset should be  non-negative and not less than the current position. " + offset + ", " + this.position);
        }
        if (this.position >= offset) {
            return true;
        }
        if (null == this.relativeSupported) {
            Boolean moreResults = null;
            StatementInfo statementInfo = this;
            synchronized (statementInfo) {
                if (null == this.relativeSupported) {
                    try {
                        moreResults = this.advanceByRelative(results, offset);
                        this.relativeSupported = true;
                    }
                    catch (SQLFeatureNotSupportedException e) {
                        this.relativeSupported = false;
                    }
                }
            }
            if (null != moreResults) {
                if (!this.relativeSupported.booleanValue()) {
                    moreResults = this.advanceByNext(results, offset);
                }
                return moreResults;
            }
        }
        if (this.relativeSupported.booleanValue()) {
            return this.advanceByRelative(results, offset);
        }
        return this.advanceByNext(results, offset);
    }

    private boolean advanceByRelative(ResultSet results, long offset) throws SQLException {
        long diff;
        for (diff = offset - this.position; diff > Integer.MAX_VALUE; diff -= Integer.MAX_VALUE) {
            if (!results.relative(Integer.MAX_VALUE)) {
                this.position += Integer.MAX_VALUE;
                return false;
            }
            this.position += Integer.MAX_VALUE;
        }
        boolean ret = results.relative((int)diff);
        this.position += diff;
        return ret;
    }

    private boolean advanceByNext(ResultSet results, long offset) throws SQLException {
        while (this.position < offset) {
            if (this._next(results)) continue;
            return false;
        }
        return true;
    }
}

