/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.inject.Injector;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.druid.guice.DruidExtensionDependencies;
import org.apache.druid.guice.ExtensionFirstClassLoader;
import org.apache.druid.guice.ExtensionsConfig;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.StandardURLClassLoader;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@LazySingleton
public class ExtensionsLoader {
    private static final Logger log = new Logger(ExtensionsLoader.class);
    public static final String DRUID_EXTENSION_DEPENDENCIES_JSON = "druid-extension-dependencies.json";
    private final ExtensionsConfig extensionsConfig;
    private final ObjectMapper objectMapper;
    @GuardedBy(value="this")
    private final HashMap<Pair<File, Boolean>, StandardURLClassLoader> loaders = new HashMap();
    @GuardedBy(value="this")
    private final HashMap<Class<?>, Collection<?>> extensions = new HashMap();
    @GuardedBy(value="this")
    private @MonotonicNonNull File[] extensionFilesToLoad;

    @Inject
    public ExtensionsLoader(ExtensionsConfig config, ObjectMapper objectMapper) {
        this.extensionsConfig = config;
        this.objectMapper = objectMapper;
    }

    public static ExtensionsLoader instance(Injector injector) {
        return (ExtensionsLoader)injector.getInstance(ExtensionsLoader.class);
    }

    public ExtensionsConfig config() {
        return this.extensionsConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Collection<T> getLoadedImplementations(Class<T> clazz) {
        ExtensionsLoader extensionsLoader = this;
        synchronized (extensionsLoader) {
            Collection<?> retVal = this.extensions.get(clazz);
            if (retVal == null) {
                return Collections.emptySet();
            }
            return retVal;
        }
    }

    public Collection<DruidModule> getLoadedModules() {
        return this.getLoadedImplementations(DruidModule.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public Map<Pair<File, Boolean>, StandardURLClassLoader> getLoadersMap() {
        ExtensionsLoader extensionsLoader = this;
        synchronized (extensionsLoader) {
            return this.loaders;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Collection<T> getFromExtensions(Class<T> serviceClass) {
        ExtensionsLoader extensionsLoader = this;
        synchronized (extensionsLoader) {
            Collection modules = this.extensions.computeIfAbsent(serviceClass, serviceC -> (ExtensionsLoader)this.new ServiceLoadingFromExtensions<T>(serviceC).implsToLoad);
            return modules;
        }
    }

    public Collection<DruidModule> getModules() {
        return this.getFromExtensions(DruidModule.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeExtensionFilesToLoad() {
        File[] extensionsToLoad;
        File rootExtensionsDir = new File(this.extensionsConfig.getDirectory());
        if (rootExtensionsDir.exists() && !rootExtensionsDir.isDirectory()) {
            throw new ISE("Root extensions directory [%s] is not a directory!?", rootExtensionsDir);
        }
        LinkedHashSet<String> toLoad = this.extensionsConfig.getLoadList();
        if (toLoad == null) {
            extensionsToLoad = rootExtensionsDir.listFiles();
        } else {
            LinkedHashSet<String> validExtensionsToLoad = new LinkedHashSet<String>(toLoad);
            if (validExtensionsToLoad.remove("druid-multi-stage-query")) {
                log.warn("Skipping extension[druid-multi-stage-query] as it is now a core capability of Druid. Please remove this extension from your configs as it will cause services to fail in future Druid versions.", new Object[0]);
            }
            int i = 0;
            extensionsToLoad = new File[validExtensionsToLoad.size()];
            for (String extensionName : validExtensionsToLoad) {
                File extensionDir = new File(extensionName);
                if (!extensionDir.isAbsolute()) {
                    extensionDir = new File(rootExtensionsDir, extensionName);
                }
                if (!extensionDir.isDirectory()) {
                    throw new ISE("Extension [%s] specified in \"druid.extensions.loadList\" didn't exist!?", extensionDir.getAbsolutePath());
                }
                extensionsToLoad[i++] = extensionDir;
            }
        }
        ExtensionsLoader extensionsLoader = this;
        synchronized (extensionsLoader) {
            this.extensionFilesToLoad = extensionsToLoad == null ? new File[]{} : extensionsToLoad;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] getExtensionFilesToLoad() {
        ExtensionsLoader extensionsLoader = this;
        synchronized (extensionsLoader) {
            if (this.extensionFilesToLoad == null) {
                this.initializeExtensionFilesToLoad();
            }
            return this.extensionFilesToLoad;
        }
    }

    public StandardURLClassLoader getClassLoaderForExtension(File extension, boolean useExtensionClassloaderFirst) {
        return this.getClassLoaderForExtension(extension, useExtensionClassloaderFirst, new ArrayList<String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StandardURLClassLoader getClassLoaderForExtension(File extension, boolean useExtensionClassloaderFirst, List<String> extensionDependencyStack) {
        Pair<File, Boolean> classLoaderKey = Pair.of(extension, useExtensionClassloaderFirst);
        ExtensionsLoader extensionsLoader = this;
        synchronized (extensionsLoader) {
            StandardURLClassLoader classLoader = this.loaders.get(classLoaderKey);
            if (classLoader == null) {
                classLoader = this.makeClassLoaderWithDruidExtensionDependencies(extension, useExtensionClassloaderFirst, extensionDependencyStack);
                this.loaders.put(classLoaderKey, classLoader);
            }
            return classLoader;
        }
    }

    private StandardURLClassLoader makeClassLoaderWithDruidExtensionDependencies(File extension, boolean useExtensionClassloaderFirst, List<String> extensionDependencyStack) {
        Optional<DruidExtensionDependencies> druidExtensionDependenciesOptional = this.getDruidExtensionDependencies(extension);
        ImmutableList druidExtensionDependenciesList = druidExtensionDependenciesOptional.isPresent() ? druidExtensionDependenciesOptional.get().getDependsOnDruidExtensions() : ImmutableList.of();
        ArrayList<ClassLoader> extensionDependencyClassLoaders = new ArrayList<ClassLoader>();
        for (String druidExtensionDependencyName : druidExtensionDependenciesList) {
            Optional<File> extensionDependencyFileOptional = Arrays.stream(this.getExtensionFilesToLoad()).filter(file -> file.getName().equals(druidExtensionDependencyName)).findFirst();
            if (!extensionDependencyFileOptional.isPresent()) {
                throw new RE(StringUtils.format("Extension [%s] depends on [%s] which is not a valid extension or not loaded.", extension.getName(), druidExtensionDependencyName), new Object[0]);
            }
            File extensionDependencyFile = extensionDependencyFileOptional.get();
            if (extensionDependencyStack.contains(extensionDependencyFile.getName())) {
                extensionDependencyStack.add(extensionDependencyFile.getName());
                throw new RE(StringUtils.format("Extension [%s] has a circular druid extension dependency. Dependency stack [%s].", extensionDependencyStack.get(0), extensionDependencyStack), new Object[0]);
            }
            extensionDependencyStack.add(extensionDependencyFile.getName());
            extensionDependencyClassLoaders.add(this.getClassLoaderForExtension(extensionDependencyFile, useExtensionClassloaderFirst, extensionDependencyStack));
        }
        return ExtensionsLoader.makeClassLoaderForExtension(extension, useExtensionClassloaderFirst, extensionDependencyClassLoaders);
    }

    private static StandardURLClassLoader makeClassLoaderForExtension(File extension, boolean useExtensionClassloaderFirst, List<ClassLoader> extensionDependencyClassLoaders) {
        Collection jars = FileUtils.listFiles((File)extension, (String[])new String[]{"jar"}, (boolean)false);
        URL[] urls = new URL[jars.size()];
        try {
            int i = 0;
            for (File jar : jars) {
                URL url = jar.toURI().toURL();
                log.debug("added URL [%s] for extension [%s]", url, extension.getName());
                urls[i++] = url;
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        if (useExtensionClassloaderFirst) {
            return new ExtensionFirstClassLoader(urls, ExtensionsLoader.class.getClassLoader(), extensionDependencyClassLoaders);
        }
        return new StandardURLClassLoader(urls, ExtensionsLoader.class.getClassLoader(), extensionDependencyClassLoaders);
    }

    public static List<URL> getURLsForClasspath(String cp) {
        try {
            String[] paths = cp.split(File.pathSeparator);
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String path : paths) {
                File f = new File(path);
                if ("*".equals(f.getName())) {
                    File[] jars;
                    File parentDir = f.getParentFile();
                    if (!parentDir.isDirectory()) continue;
                    for (File jar : jars = parentDir.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name != null && (name.endsWith(".jar") || name.endsWith(".JAR"));
                        }
                    })) {
                        urls.add(jar.toURI().toURL());
                    }
                    continue;
                }
                urls.add(new File(path).toURI().toURL());
            }
            return urls;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Optional<DruidExtensionDependencies> getDruidExtensionDependencies(File extension) {
        Collection jars = FileUtils.listFiles((File)extension, (String[])new String[]{"jar"}, (boolean)false);
        DruidExtensionDependencies druidExtensionDependencies = null;
        String druidExtensionDependenciesJarName = null;
        for (File extensionFile : jars) {
            try (JarFile jarFile = new JarFile(extensionFile.getPath());){
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (!DRUID_EXTENSION_DEPENDENCIES_JSON.equals(entryName)) continue;
                    log.debug("Found extension dependency entry in jar [%s]", extensionFile.getPath());
                    if (druidExtensionDependenciesJarName != null) {
                        throw new RE(StringUtils.format("The extension [%s] has multiple jars [%s] [%s] with dependencies in them. Each jar should be in a separate extension directory.", extension.getName(), druidExtensionDependenciesJarName, jarFile.getName()), new Object[0]);
                    }
                    druidExtensionDependencies = (DruidExtensionDependencies)this.objectMapper.readValue(jarFile.getInputStream(entry), DruidExtensionDependencies.class);
                    druidExtensionDependenciesJarName = jarFile.getName();
                }
            }
            catch (IOException e) {
                throw new RE(e, "Failed to get dependencies for extension [%s]", extension);
            }
        }
        return druidExtensionDependencies == null ? Optional.empty() : Optional.of(druidExtensionDependencies);
    }

    private class ServiceLoadingFromExtensions<T> {
        private final boolean isEmbeddedTest;
        private final Class<T> serviceClass;
        private final List<T> implsToLoad = new ArrayList<T>();
        private final Set<String> implClassNamesToLoad = new HashSet<String>();

        private ServiceLoadingFromExtensions(Class<T> serviceClass) {
            boolean bl = this.isEmbeddedTest = ExtensionsLoader.this.extensionsConfig.getModulesForEmbeddedTest() != null;
            if (this.isEmbeddedTest) {
                log.warn("Running service in embedded testing mode with allowed modules[%s]. This is an unsafe test-only mode and must never be used in a production cluster. Remove property 'druid.extensions.modulesForEmbeddedTest' to disable embedded testing mode.", ExtensionsLoader.this.extensionsConfig.getModulesForEmbeddedTest());
            }
            this.serviceClass = serviceClass;
            if (ExtensionsLoader.this.extensionsConfig.searchCurrentClassloader()) {
                this.addAllFromCurrentClassLoader();
            }
            this.addAllFromFileSystem();
        }

        private void addAllFromCurrentClassLoader() {
            ServiceLoader.load(this.serviceClass, Thread.currentThread().getContextClassLoader()).forEach(impl -> this.tryAdd(impl, "classpath"));
        }

        private void addAllFromFileSystem() {
            for (File extension : ExtensionsLoader.this.getExtensionFilesToLoad()) {
                log.debug("Loading extension [%s] for class [%s]", extension.getName(), this.serviceClass);
                try {
                    StandardURLClassLoader loader = ExtensionsLoader.this.getClassLoaderForExtension(extension, ExtensionsLoader.this.extensionsConfig.isUseExtensionClassloaderFirst());
                    log.info("Loading extension [%s], jars: %s. Druid extension dependencies [%s]", extension.getName(), Arrays.stream(loader.getURLs()).map(u -> new File(u.getPath()).getName()).collect(Collectors.joining(", ")), loader.getExtensionDependencyClassLoaders());
                    ServiceLoader.load(this.serviceClass, loader).forEach(impl -> this.tryAdd(impl, "local file system"));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private void tryAdd(T serviceImpl, String extensionType) {
            String serviceImplName = serviceImpl.getClass().getName();
            if (serviceImplName == null) {
                log.warn("Implementation %s was ignored because it doesn't have a canonical name, is it a local or anonymous class?", serviceImpl.getClass().getName());
            } else if (this.isEmbeddedTest && !ExtensionsLoader.this.extensionsConfig.getModulesForEmbeddedTest().contains(serviceImplName)) {
                log.debug("Skipping extension[%s] as it is not listed in config[%s]", serviceImplName, ExtensionsLoader.this.extensionsConfig.getModulesForEmbeddedTest());
            } else if (!this.implClassNamesToLoad.contains(serviceImplName)) {
                log.debug("Adding implementation %s for class %s from %s extension", serviceImplName, this.serviceClass, extensionType);
                this.implClassNamesToLoad.add(serviceImplName);
                this.implsToLoad.add(serviceImpl);
            }
        }
    }
}

