/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import java.util.Objects;
import org.apache.druid.java.util.common.Intervals;
import org.joda.time.Interval;
import org.joda.time.chrono.ISOChronology;

public final class FastIntervalStringFormatter {
    private static final int MILLIS_PER_SECOND = 1000;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int HOURS_PER_DAY = 24;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_DAY = 86400;
    private static final int MILLIS_PER_DAY = 86400000;
    private static final int DAYS_IN_FIVE_MONTHS = 153;
    private static final int DAYS_IN_YEAR = 365;
    private static final String ETERNITY_STRING = Intervals.ETERNITY.toString();
    private static final int ERA = 5;
    private static final long ERA_START_MILLIS = 951868800000L;
    private static final long ERA_END_MILLIS = 13574649599999L;
    private static final int RESET_OFFSET = 719468;
    private static final int DAYS_PER_ERA = 146097;
    private static final int YEARS_PER_ERA = 400;
    private static final int ERA_DAYS_OFFSET = 730485;
    private static final int ERA_OFFSET = 2000;

    public static String format(Interval interval) {
        if (Intervals.isEternity(interval)) {
            return ETERNITY_STRING;
        }
        if (!Objects.equals(interval.getChronology(), ISOChronology.getInstanceUTC()) || interval.getStartMillis() < 951868800000L || interval.getEndMillis() > 13574649599999L) {
            return interval.toString();
        }
        StringBuilder sb = new StringBuilder(49);
        FastIntervalStringFormatter.formatIntervalFromMillis(sb, interval.getStartMillis());
        sb.append("/");
        FastIntervalStringFormatter.formatIntervalFromMillis(sb, interval.getEndMillis());
        return sb.toString();
    }

    private static void formatIntervalFromMillis(StringBuilder sb, long millis) {
        FastIntervalStringFormatter.formatDateFromMillis(sb, millis);
        FastIntervalStringFormatter.formatTimeFromMillis(sb, millis);
    }

    private static void formatDateFromMillis(StringBuilder sb, long millis) {
        int daysSinceEpoch = (int)(millis / 86400000L);
        int z = daysSinceEpoch + 719468;
        int dayOfEra = z - 730485;
        int yearOfEra = (dayOfEra - dayOfEra / 1460 + dayOfEra / 36524 - dayOfEra / 146096) / 365;
        int year = yearOfEra + 2000;
        int dayOfYear = dayOfEra - (365 * yearOfEra + yearOfEra / 4 - yearOfEra / 100);
        int mp = (5 * dayOfYear + 2) / 153;
        int day = dayOfYear - (153 * mp + 2) / 5 + 1;
        int month = mp + (mp < 10 ? 3 : -9);
        sb.append(year += month <= 2 ? 1 : 0);
        sb.append('-');
        FastIntervalStringFormatter.appendPadded(sb, month, false);
        sb.append('-');
        FastIntervalStringFormatter.appendPadded(sb, day, false);
    }

    private static void formatTimeFromMillis(StringBuilder sb, long millis) {
        int millisOfDay = (int)(millis % 86400000L);
        int totalSeconds = millisOfDay / 1000;
        int milli = millisOfDay % 1000;
        int hour = totalSeconds / 3600;
        int minute = (totalSeconds -= hour * 3600) / 60;
        int second = totalSeconds - minute * 60;
        sb.append('T');
        FastIntervalStringFormatter.appendPadded(sb, hour, false);
        sb.append(':');
        FastIntervalStringFormatter.appendPadded(sb, minute, false);
        sb.append(':');
        FastIntervalStringFormatter.appendPadded(sb, second, false);
        sb.append('.');
        FastIntervalStringFormatter.appendPadded(sb, milli, true);
        sb.append('Z');
    }

    private static void appendPadded(StringBuilder sb, int value, boolean isWidth3) {
        if (value < 10) {
            sb.append('0');
        }
        if (isWidth3 && value < 100) {
            sb.append('0');
        }
        sb.append(value);
    }

    private FastIntervalStringFormatter() {
    }
}

