/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import java.lang.reflect.Field;

public class UnsafeUtils {
    private static final Object UNSAFE;
    private static final Class<?> UNSAFE_CLASS;
    private static final Exception UNSAFE_NOT_SUPPORTED_EXCEPTION;
    private static final String MESSAGE = "sun.misc.Unsafe is not supported on this platform, because internal Java APIs are not compatible with this Druid version";

    public static Object theUnsafe() {
        if (UNSAFE != null) {
            return UNSAFE;
        }
        throw new UnsupportedOperationException(MESSAGE, UNSAFE_NOT_SUPPORTED_EXCEPTION);
    }

    public static Class<?> theUnsafeClass() {
        if (UNSAFE_CLASS != null) {
            return UNSAFE_CLASS;
        }
        throw new UnsupportedOperationException(MESSAGE, UNSAFE_NOT_SUPPORTED_EXCEPTION);
    }

    static {
        Object theUnsafe = null;
        Class<?> unsafeClass = null;
        Exception exception = null;
        try {
            unsafeClass = Class.forName("sun.misc.Unsafe");
            Field f = unsafeClass.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            theUnsafe = f.get(null);
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            exception = e;
        }
        if (theUnsafe != null) {
            UNSAFE = theUnsafe;
            UNSAFE_CLASS = unsafeClass;
            UNSAFE_NOT_SUPPORTED_EXCEPTION = exception;
        } else {
            UNSAFE_CLASS = null;
            UNSAFE = null;
            UNSAFE_NOT_SUPPORTED_EXCEPTION = exception;
        }
    }
}

