/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Map;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.CgroupUtil;
import org.apache.druid.java.util.metrics.CgroupV2CpuMonitor;
import org.apache.druid.java.util.metrics.FeedDefiningMonitor;
import org.apache.druid.java.util.metrics.KeyedDiff;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.CgroupVersion;
import org.apache.druid.java.util.metrics.cgroups.Cpu;
import org.apache.druid.java.util.metrics.cgroups.ProcSelfCgroupDiscoverer;

public class CgroupCpuMonitor
extends FeedDefiningMonitor {
    private static final Logger LOG = new Logger(CgroupCpuMonitor.class);
    private static final Long DEFAULT_USER_HZ = 100L;
    final CgroupDiscoverer cgroupDiscoverer;
    private Long userHz;
    private final KeyedDiff jiffies = new KeyedDiff();
    private long prevJiffiesSnapshotAt = 0L;
    private final boolean isRunningOnCgroupsV2;
    private final CgroupV2CpuMonitor cgroupV2CpuMonitor;

    public CgroupCpuMonitor(CgroupDiscoverer cgroupDiscoverer, String feed) {
        super(feed);
        this.cgroupDiscoverer = cgroupDiscoverer;
        this.isRunningOnCgroupsV2 = cgroupDiscoverer.getCgroupVersion().equals((Object)CgroupVersion.V2);
        if (this.isRunningOnCgroupsV2) {
            this.cgroupV2CpuMonitor = new CgroupV2CpuMonitor(cgroupDiscoverer, feed);
            LOG.info("Detected cgroups v2, using CgroupV2CpuMonitor behavior for accurate metrics", new Object[0]);
        } else {
            this.cgroupV2CpuMonitor = null;
            this.initUzerHz();
        }
    }

    public CgroupCpuMonitor(String feed) {
        this(ProcSelfCgroupDiscoverer.autoCgroupDiscoverer(), feed);
    }

    public CgroupCpuMonitor() {
        this("metrics");
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        if (this.isRunningOnCgroupsV2) {
            return this.cgroupV2CpuMonitor.doMonitor(emitter);
        }
        return this.doMonitorV1(emitter);
    }

    private boolean doMonitorV1(ServiceEmitter emitter) {
        Cpu.CpuMetrics cpuSnapshot = this.cgroupDiscoverer.getCpuMetrics();
        long now = Instant.now().getEpochSecond();
        ServiceMetricEvent.Builder builder = this.builder();
        builder.setDimension("cgroupversion", this.cgroupDiscoverer.getCgroupVersion().name());
        emitter.emit(builder.setMetric("cgroup/cpu/shares", cpuSnapshot.getShares()));
        emitter.emit(builder.setMetric("cgroup/cpu/cores_quota", CgroupUtil.computeProcessorQuota(cpuSnapshot.getQuotaUs(), cpuSnapshot.getPeriodUs())));
        long elapsedJiffiesSnapshotSecs = now - this.prevJiffiesSnapshotAt;
        if (elapsedJiffiesSnapshotSecs > 0L) {
            this.prevJiffiesSnapshotAt = now;
            Map<String, Long> elapsedJiffies = this.jiffies.to("usage", (Map<String, Long>)ImmutableMap.builder().put((Object)"user", (Object)cpuSnapshot.getUserJiffies()).put((Object)"system", (Object)cpuSnapshot.getSystemJiffies()).put((Object)"total", (Object)cpuSnapshot.getTotalJiffies()).build());
            if (elapsedJiffies != null) {
                double totalUsagePct = 100.0 * (double)elapsedJiffies.get("total").longValue() / (double)this.userHz.longValue() / (double)elapsedJiffiesSnapshotSecs;
                double sysUsagePct = 100.0 * (double)elapsedJiffies.get("system").longValue() / (double)this.userHz.longValue() / (double)elapsedJiffiesSnapshotSecs;
                double userUsagePct = 100.0 * (double)elapsedJiffies.get("user").longValue() / (double)this.userHz.longValue() / (double)elapsedJiffiesSnapshotSecs;
                emitter.emit(builder.setMetric("cgroup/cpu/usage/total/percentage", totalUsagePct));
                emitter.emit(builder.setMetric("cgroup/cpu/usage/sys/percentage", sysUsagePct));
                emitter.emit(builder.setMetric("cgroup/cpu/usage/user/percentage", userUsagePct));
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUzerHz() {
        try {
            Process p = new ProcessBuilder("getconf", "CLK_TCK").start();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream(), StandardCharsets.UTF_8));){
                String line = in.readLine();
                if (line != null) {
                    this.userHz = Long.valueOf(line.trim());
                }
            }
        }
        catch (IOException | NumberFormatException e) {
            LOG.warn(e, "Error getting the USER_HZ value", new Object[0]);
        }
        finally {
            if (this.userHz == null) {
                LOG.warn("Using default value for USER_HZ", new Object[0]);
                this.userHz = DEFAULT_USER_HZ;
            }
        }
    }
}

