/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics.cgroups;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;

public class CpuSet {
    private static final Logger LOG = new Logger(CpuSet.class);
    private static final String CGROUP = "cpuset";
    private static final String CPUS_FILE = "cpuset.cpus";
    private static final String EFFECTIVE_CPUS_FILE = "cpuset.effective_cpus";
    private static final String MEMS_FILE = "cpuset.mems";
    private static final String EFFECTIVE_MEMS_FILE = "cpuset.effective_mems";
    private final CgroupDiscoverer cgroupDiscoverer;

    public CpuSet(CgroupDiscoverer cgroupDiscoverer) {
        this.cgroupDiscoverer = cgroupDiscoverer;
    }

    public CpuSetMetric snapshot() {
        return new CpuSetMetric(this.readCpuSetFile(CPUS_FILE), this.readCpuSetFile(EFFECTIVE_CPUS_FILE), this.readCpuSetFile(MEMS_FILE), this.readCpuSetFile(EFFECTIVE_MEMS_FILE));
    }

    private int[] readCpuSetFile(String file) {
        int[] output = new int[]{};
        try {
            List<String> lines = Files.readAllLines(Paths.get(this.cgroupDiscoverer.discover(CGROUP).toString(), file));
            output = lines.stream().map(CpuSet::parseStringRangeToIntArray).findFirst().orElse(output);
        }
        catch (IOException | RuntimeException ex) {
            LOG.noStackTrace().warn(ex, "Unable to read %s, these metrics will be skipped", file);
        }
        return output;
    }

    public static int[] parseStringRangeToIntArray(String line) {
        String[] cpuParts = line.split(",");
        return Arrays.stream(cpuParts).flatMapToInt(cpuPart -> {
            Integer bit;
            String[] bits = (cpuPart = cpuPart.trim()).split("-");
            if (bits.length == 2) {
                Integer low = Ints.tryParse((String)bits[0].trim());
                Integer high = Ints.tryParse((String)bits[1].trim());
                if (low != null && high != null) {
                    return IntStream.rangeClosed(low, high);
                }
            } else if (bits.length == 1 && (bit = Ints.tryParse((String)bits[0].trim())) != null) {
                return IntStream.of((int)bit);
            }
            return IntStream.empty();
        }).toArray();
    }

    public static class CpuSetMetric {
        private final int[] cpuSetCpus;
        private final int[] effectiveCpuSetCpus;
        private final int[] cpuSetMems;
        private final int[] effectiveCpuSetMems;

        CpuSetMetric(int[] cpuSetCpus, int[] effectiveCpuSetCpus, int[] cpuSetMems, int[] effectiveCpuSetMems) {
            this.cpuSetCpus = cpuSetCpus;
            this.effectiveCpuSetCpus = effectiveCpuSetCpus;
            this.cpuSetMems = cpuSetMems;
            this.effectiveCpuSetMems = effectiveCpuSetMems;
        }

        public int[] getCpuSetCpus() {
            return this.cpuSetCpus;
        }

        public int[] getEffectiveCpuSetCpus() {
            return this.effectiveCpuSetCpus;
        }

        public int[] getCpuSetMems() {
            return this.cpuSetMems;
        }

        public int[] getEffectiveCpuSetMems() {
            return this.effectiveCpuSetMems;
        }
    }
}

