/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.query.aggregation.AbstractSerializablePairLongObjectBufferStore;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.file.SegmentFileBuilder;
import org.apache.druid.segment.serde.cell.ByteBufferProvider;
import org.apache.druid.segment.serde.cell.StagedSerde;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public abstract class AbstractSerializablePairLongObjectColumnSerializer<T extends SerializablePair<Long, ?>>
implements GenericColumnSerializer<T> {
    public final StagedSerde<T> stagedSerde;
    final SegmentWriteOutMedium segmentWriteOutMedium;
    private final ByteBufferProvider byteBufferProvider;
    State state = State.START;
    AbstractSerializablePairLongObjectBufferStore<T> bufferStore;
    private AbstractSerializablePairLongObjectBufferStore.TransferredBuffer transferredBuffer;

    AbstractSerializablePairLongObjectColumnSerializer(StagedSerde<T> stagedSerde, SegmentWriteOutMedium segmentWriteOutMedium, ByteBufferProvider byteBufferProvider) {
        this.stagedSerde = stagedSerde;
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.byteBufferProvider = byteBufferProvider;
    }

    @Override
    public void serialize(ColumnValueSelector<? extends T> selector) throws IOException {
        Preconditions.checkState((this.state == State.OPEN ? 1 : 0) != 0, (String)"serialize called in invalid state %s", (Object)((Object)this.state));
        SerializablePair pairLongObject = (SerializablePair)selector.getObject();
        this.bufferStore.store(pairLongObject);
    }

    @Override
    public long getSerializedSize() throws IOException {
        Preconditions.checkState((this.state != State.START ? 1 : 0) != 0, (String)"getSerializedSize called in invalid state %s (must have opened at least)", (Object)((Object)this.state));
        this.transferToRowWriterIfNecessary();
        return this.transferredBuffer.getSerializedSize();
    }

    @Override
    public void writeTo(WritableByteChannel channel, SegmentFileBuilder fileBuilder) throws IOException {
        Preconditions.checkState((this.state != State.START ? 1 : 0) != 0, (String)"writeTo called in invalid state %s", (Object)((Object)this.state));
        this.transferToRowWriterIfNecessary();
        this.transferredBuffer.writeTo(channel, fileBuilder);
    }

    private void transferToRowWriterIfNecessary() throws IOException {
        if (this.state == State.OPEN) {
            this.transferredBuffer = this.bufferStore.transferToRowWriter(this.byteBufferProvider, this.segmentWriteOutMedium);
            this.state = State.CLOSED;
        }
    }

    static enum State {
        START,
        OPEN,
        CLOSED;

    }
}

