/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.extraction;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.js.JavaScriptConfig;
import org.apache.druid.query.extraction.ExtractionFn;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavaScriptExtractionFn
implements ExtractionFn {
    private final String function;
    private final boolean injective;
    private final JavaScriptConfig config;
    private volatile @MonotonicNonNull Function<Object, String> fn;

    private static Function<Object, String> compile(String function) {
        final ContextFactory contextFactory = ContextFactory.getGlobal();
        Context context = contextFactory.enterContext();
        context.setOptimizationLevel(9);
        final ScriptableObject scope = context.initStandardObjects();
        final org.mozilla.javascript.Function fn = context.compileFunction((Scriptable)scope, function, "fn", 1, null);
        Context.exit();
        return new Function<Object, String>(){

            public String apply(Object input) {
                Object res;
                Context cx = Context.getCurrentContext();
                if (cx == null) {
                    cx = contextFactory.enterContext();
                }
                return (res = fn.call(cx, (Scriptable)scope, (Scriptable)scope, new Object[]{input})) != null ? Context.toString((Object)res) : null;
            }
        };
    }

    @JsonCreator
    public JavaScriptExtractionFn(@JsonProperty(value="function") String function, @JsonProperty(value="injective") boolean injective, @JacksonInject JavaScriptConfig config) {
        Preconditions.checkNotNull((Object)function, (Object)"function must not be null");
        this.function = function;
        this.injective = injective;
        this.config = config;
    }

    @JsonProperty
    public String getFunction() {
        return this.function;
    }

    @JsonProperty
    public boolean isInjective() {
        return this.injective;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] bytes = StringUtils.toUtf8(this.function);
        return ByteBuffer.allocate(1 + bytes.length).put((byte)4).put(bytes).array();
    }

    @Override
    @Nullable
    public String apply(@Nullable Object value) {
        Function<Object, String> fn = this.getCompiledScript();
        return (String)fn.apply(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EnsuresNonNull(value={"fn"})
    private Function<Object, String> getCompiledScript() {
        Preconditions.checkState((boolean)this.config.isEnabled(), (Object)"JavaScript is disabled");
        Function<Object, String> syncedFn = this.fn;
        if (syncedFn == null) {
            JavaScriptConfig javaScriptConfig = this.config;
            synchronized (javaScriptConfig) {
                syncedFn = this.fn;
                if (syncedFn == null) {
                    this.fn = syncedFn = JavaScriptExtractionFn.compile(this.function);
                }
            }
        }
        return syncedFn;
    }

    @Override
    @Nullable
    public String apply(@Nullable String value) {
        return this.apply((Object)value);
    }

    @Override
    public String apply(long value) {
        return this.apply((Object)value);
    }

    @Override
    public boolean preservesOrdering() {
        return false;
    }

    @Override
    public ExtractionFn.ExtractionType getExtractionType() {
        return this.injective ? ExtractionFn.ExtractionType.ONE_TO_ONE : ExtractionFn.ExtractionType.MANY_TO_ONE;
    }

    public String toString() {
        return "JavascriptDimExtractionFn{function='" + this.function + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaScriptExtractionFn that = (JavaScriptExtractionFn)o;
        return this.function.equals(that.function);
    }

    public int hashCode() {
        return this.function.hashCode();
    }
}

