/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.filter.TrueDimFilter;

public class DimFilters {
    public static SelectorDimFilter dimEquals(String dimension, String value) {
        return new SelectorDimFilter(dimension, value, null);
    }

    public static AndDimFilter and(DimFilter ... filters) {
        return DimFilters.and(Arrays.asList(filters));
    }

    public static AndDimFilter and(List<DimFilter> filters) {
        return new AndDimFilter(filters);
    }

    public static OrDimFilter or(DimFilter ... filters) {
        return DimFilters.or(Arrays.asList(filters));
    }

    public static OrDimFilter or(List<DimFilter> filters) {
        return new OrDimFilter(filters);
    }

    public static NotDimFilter not(DimFilter filter) {
        return new NotDimFilter(filter);
    }

    public static List<DimFilter> optimize(List<DimFilter> filters, boolean mayIncludeUnknown) {
        return DimFilters.filterNulls(Lists.transform(filters, filter -> filter.optimize(mayIncludeUnknown)));
    }

    public static List<DimFilter> filterNulls(List<DimFilter> optimized) {
        return Lists.newArrayList((Iterable)Iterables.filter(optimized, (Predicate)Predicates.notNull()));
    }

    public static DimFilter conjunction(List<DimFilter> filters) {
        switch (filters.size()) {
            case 0: {
                return TrueDimFilter.instance();
            }
            case 1: {
                return filters.get(0);
            }
        }
        return DimFilters.and(filters);
    }

    public static DimFilter conjunction(DimFilter ... filters) {
        List<DimFilter> list = Arrays.stream(filters).filter(v -> v != null && !TrueDimFilter.instance().equals(v)).collect(Collectors.toList());
        return DimFilters.conjunction(list);
    }
}

