/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import org.apache.druid.query.operator.AbstractPartitioningOperatorFactory;
import org.apache.druid.query.operator.GlueingPartitioningOperator;
import org.apache.druid.query.operator.Operator;
import org.apache.druid.query.operator.OperatorFactory;

public class GlueingPartitioningOperatorFactory
extends AbstractPartitioningOperatorFactory {
    private final Integer maxRowsMaterialized;

    @JsonCreator
    public GlueingPartitioningOperatorFactory(@JsonProperty(value="partitionColumns") List<String> partitionColumns, @JsonProperty(value="maxRowsMaterialized") Integer maxRowsMaterialized) {
        super(partitionColumns);
        this.maxRowsMaterialized = maxRowsMaterialized;
    }

    @JsonProperty(value="maxRowsMaterialized")
    public Integer getMaxRowsMaterialized() {
        return this.maxRowsMaterialized;
    }

    @Override
    public Operator wrap(Operator op) {
        return new GlueingPartitioningOperator(op, this.partitionColumns, this.maxRowsMaterialized);
    }

    @Override
    public boolean validateEquivalent(OperatorFactory other) {
        if (!super.validateEquivalent(other)) {
            return false;
        }
        if (!(other instanceof GlueingPartitioningOperatorFactory)) {
            return false;
        }
        return Objects.equals(this.maxRowsMaterialized, ((GlueingPartitioningOperatorFactory)other).getMaxRowsMaterialized());
    }

    @Override
    public String toString() {
        return "GlueingPartitioningOperatorFactory{partitionColumns=" + String.valueOf(this.partitionColumns) + "maxRowsMaterialized=" + this.maxRowsMaterialized + "}";
    }

    @Override
    public final int hashCode() {
        return Objects.hash(this.partitionColumns, this.maxRowsMaterialized);
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && Objects.equals(this.maxRowsMaterialized, ((GlueingPartitioningOperatorFactory)obj).getMaxRowsMaterialized());
    }
}

