/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.column;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.query.rowsandcols.column.BinarySearchableAccessor;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.query.rowsandcols.util.FindResult;
import org.apache.druid.segment.column.ColumnType;

public class NullColumn
implements Column {
    private final ColumnType type;
    private final int numRows;

    public NullColumn(ColumnType type, int numRows) {
        this.type = type;
        this.numRows = numRows;
    }

    @Override
    @Nonnull
    public ColumnAccessor toAccessor() {
        return new Accessor(this.type, this.numRows);
    }

    @Override
    @Nullable
    public <T> T as(Class<? extends T> clazz) {
        return null;
    }

    public static class Accessor
    implements BinarySearchableAccessor {
        private final ColumnType type;
        private final int size;

        public Accessor(ColumnType type, int size) {
            this.type = type;
            this.size = size;
        }

        @Override
        public ColumnType getType() {
            return this.type;
        }

        @Override
        public int numRows() {
            return this.size;
        }

        @Override
        public boolean isNull(int rowNum) {
            return true;
        }

        @Override
        @Nullable
        public Object getObject(int rowNum) {
            return null;
        }

        @Override
        public double getDouble(int rowNum) {
            return 0.0;
        }

        @Override
        public float getFloat(int rowNum) {
            return 0.0f;
        }

        @Override
        public long getLong(int rowNum) {
            return 0L;
        }

        @Override
        public int getInt(int rowNum) {
            return 0;
        }

        @Override
        public int compareRows(int lhsRowNum, int rhsRowNum) {
            return 0;
        }

        @Override
        public FindResult findNull(int startIndex, int endIndex) {
            return FindResult.found(startIndex, endIndex);
        }

        @Override
        public FindResult findDouble(int startIndex, int endIndex, double val) {
            return FindResult.notFound(endIndex);
        }

        @Override
        public FindResult findFloat(int startIndex, int endIndex, float val) {
            return FindResult.notFound(endIndex);
        }

        @Override
        public FindResult findLong(int startIndex, int endIndex, long val) {
            return FindResult.notFound(endIndex);
        }

        @Override
        public FindResult findString(int startIndex, int endIndex, String val) {
            return FindResult.notFound(endIndex);
        }

        @Override
        public FindResult findComplex(int startIndex, int endIndex, Object val) {
            return FindResult.notFound(endIndex);
        }
    }
}

