/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Comparator;
import java.util.Objects;
import org.apache.druid.segment.projections.AggregateProjectionSchema;
import org.apache.druid.segment.projections.ProjectionMetadata;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonTypeName(value="aggregate")
public class AggregateProjectionMetadata {
    public static final Comparator<AggregateProjectionMetadata> COMPARATOR = (o1, o2) -> {
        int rowCompare = Integer.compare(o1.numRows, o2.numRows);
        if (rowCompare != 0) {
            return rowCompare;
        }
        return AggregateProjectionSchema.COMPARATOR.compare(o1.getSchema(), o2.getSchema());
    };
    private final AggregateProjectionSchema schema;
    private final int numRows;

    @JsonCreator
    public AggregateProjectionMetadata(@JsonProperty(value="schema") AggregateProjectionSchema schema, @JsonProperty(value="numRows") int numRows) {
        this.schema = (AggregateProjectionSchema)ProjectionMetadata.SCHEMA_INTERNER.intern((Object)schema);
        this.numRows = numRows;
    }

    @JsonProperty
    public AggregateProjectionSchema getSchema() {
        return this.schema;
    }

    @JsonProperty
    public int getNumRows() {
        return this.numRows;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregateProjectionMetadata that = (AggregateProjectionMetadata)o;
        return this.numRows == that.numRows && Objects.equals(this.schema, that.schema);
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.numRows);
    }

    public String toString() {
        return "AggregateProjectionMetadata{schema=" + String.valueOf(this.schema) + ", numRows=" + this.numRows + "}";
    }
}

