/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.AggregateProjectionMetadata;
import org.apache.druid.segment.BaseProgressIndicator;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.DimensionMergerV9;
import org.apache.druid.segment.DoubleColumnSerializerV2;
import org.apache.druid.segment.FloatColumnSerializerV2;
import org.apache.druid.segment.ForwardingRowIterator;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.IndexableAdapter;
import org.apache.druid.segment.LongColumnSerializerV2;
import org.apache.druid.segment.MergingRowIterator;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.ProgressIndicator;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexIndexableAdapter;
import org.apache.druid.segment.RowCombiningTimeAndDimsIterator;
import org.apache.druid.segment.RowPointer;
import org.apache.druid.segment.SegmentLazyLoadFailCallback;
import org.apache.druid.segment.TimeAndDimsIterator;
import org.apache.druid.segment.TimeAndDimsPointer;
import org.apache.druid.segment.TransformableRowIterator;
import org.apache.druid.segment.column.ColumnDescriptor;
import org.apache.druid.segment.column.ColumnFormat;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.file.SegmentFileBuilder;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexAdapter;
import org.apache.druid.segment.projections.AggregateProjectionSchema;
import org.apache.druid.segment.projections.Projections;
import org.apache.druid.segment.serde.ColumnPartSerde;
import org.apache.druid.segment.serde.ComplexColumnPartSerde;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;
import org.apache.druid.segment.serde.DoubleNumericColumnPartSerdeV2;
import org.apache.druid.segment.serde.FloatNumericColumnPartSerdeV2;
import org.apache.druid.segment.serde.LongNumericColumnPartSerdeV2;
import org.apache.druid.segment.serde.NullColumnPartSerde;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public abstract class IndexMergerBase
implements IndexMerger {
    protected final ObjectMapper mapper;
    protected final IndexIO indexIO;
    protected final SegmentWriteOutMediumFactory defaultSegmentWriteOutMediumFactory;

    protected IndexMergerBase(ObjectMapper mapper, IndexIO indexIO, SegmentWriteOutMediumFactory defaultSegmentWriteOutMediumFactory) {
        this.mapper = (ObjectMapper)Preconditions.checkNotNull((Object)mapper, (Object)"null ObjectMapper");
        this.indexIO = (IndexIO)Preconditions.checkNotNull((Object)indexIO, (Object)"null IndexIO");
        this.defaultSegmentWriteOutMediumFactory = (SegmentWriteOutMediumFactory)Preconditions.checkNotNull((Object)defaultSegmentWriteOutMediumFactory, (Object)"null SegmentWriteOutMediumFactory");
    }

    protected abstract boolean shouldStoreEmptyColumns();

    protected abstract File makeIndexFiles(List<IndexableAdapter> var1, @Nullable Metadata var2, File var3, ProgressIndicator var4, List<String> var5, DimensionsSpecInspector var6, List<String> var7, Function<List<TransformableRowIterator>, TimeAndDimsIterator> var8, IndexSpec var9, @Nullable SegmentWriteOutMediumFactory var10) throws IOException;

    protected abstract void makeColumn(SegmentFileBuilder var1, String var2, ColumnDescriptor var3) throws IOException;

    @Override
    public File persist(IncrementalIndex index, Interval dataInterval, File outDir, IndexSpec indexSpec, ProgressIndicator progress, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) throws IOException {
        if (index.isEmpty()) {
            throw new IAE("Trying to persist an empty index!", new Object[0]);
        }
        indexSpec = indexSpec.getEffectiveSpec();
        DateTime firstTimestamp = index.getMinTime();
        DateTime lastTimestamp = index.getMaxTime();
        if (!dataInterval.contains((ReadableInstant)firstTimestamp) || !dataInterval.contains((ReadableInstant)lastTimestamp)) {
            throw new IAE("interval[%s] does not encapsulate the full range of timestamps[%s, %s]", dataInterval, firstTimestamp, lastTimestamp);
        }
        FileUtils.mkdirp(outDir);
        log.debug("Starting persist for interval[%s], rows[%,d]", dataInterval, index.numRows());
        return this.multiphaseMerge(Collections.singletonList(new IncrementalIndexAdapter(dataInterval, index, indexSpec.getBitmapSerdeFactory().getBitmapFactory())), false, index.getMetricAggs(), index.getDimensionsSpec(), outDir, indexSpec, indexSpec, progress, segmentWriteOutMediumFactory, -1);
    }

    @Override
    public File mergeQueryableIndex(List<QueryableIndex> indexes, boolean rollup, AggregatorFactory[] metricAggs, @Nullable DimensionsSpec dimensionsSpec, File outDir, IndexSpec indexSpec, IndexSpec indexSpecForIntermediatePersists, ProgressIndicator progress, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, int maxColumnsToMerge) throws IOException {
        return this.multiphaseMerge(IndexMerger.toIndexableAdapters(indexes), rollup, metricAggs, dimensionsSpec, outDir, indexSpec, indexSpecForIntermediatePersists, progress, segmentWriteOutMediumFactory, maxColumnsToMerge);
    }

    @Override
    public File merge(List<IndexableAdapter> indexes, boolean rollup, AggregatorFactory[] metricAggs, File outDir, DimensionsSpec dimensionsSpec, IndexSpec indexSpec, int maxColumnsToMerge) throws IOException {
        return this.multiphaseMerge(indexes, rollup, metricAggs, dimensionsSpec, outDir, indexSpec, indexSpec, new BaseProgressIndicator(), null, maxColumnsToMerge);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected File multiphaseMerge(List<IndexableAdapter> indexes, boolean rollup, AggregatorFactory[] metricAggs, @Nullable DimensionsSpec dimensionsSpec, File outDir, IndexSpec indexSpec, IndexSpec indexSpecForIntermediatePersists, ProgressIndicator progress, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, int maxColumnsToMerge) throws IOException {
        FileUtils.deleteDirectory(outDir);
        FileUtils.mkdirp(outDir);
        tempDirs = new ArrayList<File>();
        indexSpec = indexSpec.getEffectiveSpec();
        indexSpecForIntermediatePersists = indexSpecForIntermediatePersists.getEffectiveSpec();
        IndexMergerBase.log.info("Building segment with IndexSpec[%s]", new Object[]{indexSpec});
        if (maxColumnsToMerge == -1) {
            return this.merge(indexes, rollup, metricAggs, dimensionsSpec, outDir, indexSpec, progress, segmentWriteOutMediumFactory);
        }
        currentPhases = this.getMergePhases(indexes, maxColumnsToMerge);
        currentOutputs = new ArrayList<File>();
        IndexMergerBase.log.debug("Base outDir[%s]", new Object[]{outDir});
        try {
            tierCounter = 0;
lbl14:
            // 2 sources

            while (true) {
                IndexMergerBase.log.info("Merging phases[%,d] (indexes[%,d], maxColumnsToMerge[%,d]), tiers finished processed so far[%,d].", new Object[]{currentPhases.size(), indexes.size(), maxColumnsToMerge, tierCounter});
                for (List<IndexableAdapter> phase : currentPhases) {
                    v0 = isFinalPhase = currentPhases.size() == 1;
                    if (isFinalPhase) {
                        phaseOutDir = outDir;
                        IndexMergerBase.log.info("Performing final merge phase.", new Object[0]);
                    } else {
                        phaseOutDir = FileUtils.createTempDir();
                        tempDirs.add(phaseOutDir);
                    }
                    IndexMergerBase.log.info("Merging phase with index count[%,d].", new Object[]{phase.size()});
                    IndexMergerBase.log.debug("Phase outDir[%s]", new Object[]{phaseOutDir});
                    phaseOutput = this.merge(phase, rollup, metricAggs, dimensionsSpec, phaseOutDir, isFinalPhase != false ? indexSpec : indexSpecForIntermediatePersists, progress, segmentWriteOutMediumFactory);
                    currentOutputs.add(phaseOutput);
                }
                if (currentOutputs.size() == 1) {
                    var15_15 = (File)currentOutputs.get(0);
                    var16_16 = tempDirs.iterator();
                }
                ** GOTO lbl-1000
                break;
            }
        }
        catch (Throwable var20_22) {
            var21_23 = tempDirs.iterator();
            while (true) {
                if (!var21_23.hasNext()) {
                    throw var20_22;
                }
                tempDir = (File)var21_23.next();
                if (!tempDir.exists()) continue;
                try {
                    FileUtils.deleteDirectory(tempDir);
                }
                catch (Exception e) {
                    IndexMergerBase.log.warn(e, "Failed to remove directory[%s]", new Object[]{tempDir});
                }
            }
        }
        while (true) {
            if (!var16_16.hasNext()) {
                return var15_15;
            }
            tempDir = (File)var16_16.next();
            if (!tempDir.exists()) continue;
            try {
                FileUtils.deleteDirectory(tempDir);
            }
            catch (Exception e) {
                IndexMergerBase.log.warn(e, "Failed to remove directory[%s]", new Object[]{tempDir});
            }
        }
lbl-1000:
        // 1 sources

        {
            qIndexAdapters = new ArrayList<IndexableAdapter>();
            for (File outputFile : currentOutputs) {
                qIndex = this.indexIO.loadIndex(outputFile, true, SegmentLazyLoadFailCallback.NOOP);
                qIndexAdapters.add(new QueryableIndexIndexableAdapter(qIndex));
            }
            currentPhases = this.getMergePhases(qIndexAdapters, maxColumnsToMerge);
            currentOutputs = new ArrayList<E>();
            ++tierCounter;
            ** continue;
        }
    }

    protected List<List<IndexableAdapter>> getMergePhases(List<IndexableAdapter> indexes, int maxColumnsToMerge) {
        ArrayList<List<IndexableAdapter>> toMerge = new ArrayList<List<IndexableAdapter>>();
        if (indexes.size() <= 2) {
            if (this.getIndexColumnCount(indexes) > maxColumnsToMerge) {
                log.info("index pair has more columns than maxColumnsToMerge [%d].", maxColumnsToMerge);
            }
            toMerge.add(indexes);
        } else {
            ArrayList<IndexableAdapter> currentPhase = new ArrayList<IndexableAdapter>();
            int currentColumnCount = 0;
            for (IndexableAdapter index : indexes) {
                int indexColumnCount = this.getIndexColumnCount(index);
                if (indexColumnCount > maxColumnsToMerge) {
                    log.info("index has more columns [%d] than maxColumnsToMerge [%d]!", indexColumnCount, maxColumnsToMerge);
                }
                if (currentPhase.size() > 1 && currentColumnCount + indexColumnCount > maxColumnsToMerge) {
                    toMerge.add(currentPhase);
                    currentPhase = new ArrayList();
                    currentColumnCount = indexColumnCount;
                    currentPhase.add(index);
                    continue;
                }
                currentPhase.add(index);
                currentColumnCount += indexColumnCount;
            }
            toMerge.add(currentPhase);
        }
        return toMerge;
    }

    protected int getIndexColumnCount(IndexableAdapter indexableAdapter) {
        return indexableAdapter.getDimensionNames(true).size() + indexableAdapter.getMetricNames().size();
    }

    protected int getIndexColumnCount(List<IndexableAdapter> indexableAdapters) {
        int count = 0;
        for (IndexableAdapter indexableAdapter : indexableAdapters) {
            count += this.getIndexColumnCount(indexableAdapter);
        }
        return count;
    }

    protected File merge(List<IndexableAdapter> indexes, boolean rollup, AggregatorFactory[] metricAggs, @Nullable DimensionsSpec dimensionsSpec, File outDir, IndexSpec indexSpec, ProgressIndicator progress, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) throws IOException {
        int i;
        List<String> mergedDimensionsWithTime = IndexMerger.getMergedDimensionsWithTime(indexes, dimensionsSpec);
        ArrayList<String> mergedMetrics = IndexMerger.mergeIndexed(indexes.stream().map(IndexableAdapter::getMetricNames).collect(Collectors.toList()));
        AggregatorFactory[] sortedMetricAggs = new AggregatorFactory[mergedMetrics.size()];
        for (AggregatorFactory metricAgg : metricAggs) {
            int metricIndex = mergedMetrics.indexOf(metricAgg.getName());
            if (metricIndex <= -1) continue;
            sortedMetricAggs[metricIndex] = metricAgg;
        }
        for (i = 0; i < sortedMetricAggs.length; ++i) {
            if (sortedMetricAggs[i] != null) continue;
            throw new IAE("Indices to merge contained metric[%s], but requested metrics did not", mergedMetrics.get(i));
        }
        for (i = 0; i < mergedMetrics.size(); ++i) {
            if (sortedMetricAggs[i].getName().equals(mergedMetrics.get(i))) continue;
            throw new IAE("Metric mismatch, index[%d] [%s] != [%s]", i, sortedMetricAggs[i].getName(), mergedMetrics.get(i));
        }
        Function<List<TransformableRowIterator>, TimeAndDimsIterator> rowMergerFn = rollup ? rowIterators -> new RowCombiningTimeAndDimsIterator((List<TransformableRowIterator>)rowIterators, sortedMetricAggs, (List<String>)mergedMetrics) : MergingRowIterator::new;
        List metadataList = Lists.transform(indexes, IndexableAdapter::getMetadata);
        AggregatorFactory[] combiningMetricAggs = new AggregatorFactory[sortedMetricAggs.length];
        for (int i2 = 0; i2 < sortedMetricAggs.length; ++i2) {
            combiningMetricAggs[i2] = sortedMetricAggs[i2].getCombiningFactory();
        }
        Metadata segmentMetadata = Metadata.merge(metadataList, combiningMetricAggs);
        if (segmentMetadata != null && segmentMetadata.getOrdering() != null && segmentMetadata.getOrdering().stream().noneMatch(orderBy -> "__time".equals(orderBy.getColumnName()))) {
            throw DruidException.defensive("sortOrder[%s] must include[%s]", segmentMetadata.getOrdering(), "__time");
        }
        return this.makeIndexFiles(indexes, segmentMetadata, outDir, progress, mergedDimensionsWithTime, new DimensionsSpecInspector(this.shouldStoreEmptyColumns(), dimensionsSpec), mergedMetrics, rowMergerFn, indexSpec, segmentWriteOutMediumFactory);
    }

    protected Metadata makeProjections(SegmentFileBuilder segmentFileBuilder, List<AggregateProjectionMetadata> projections, List<IndexableAdapter> adapters, IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium, ProgressIndicator progress, File segmentBaseDir, Closer closer, Map<String, DimensionMergerV9> parentMergers, Metadata segmentMetadata) throws IOException {
        ArrayList projectionMetadata = Lists.newArrayListWithCapacity((int)projections.size());
        for (AggregateProjectionMetadata spec : projections) {
            long startTime;
            ArrayList projectionAdapters = Lists.newArrayListWithCapacity((int)adapters.size());
            AggregateProjectionSchema projectionSchema = spec.getSchema();
            for (IndexableAdapter adapter : adapters) {
                projectionAdapters.add(adapter.getProjectionAdapter(projectionSchema.getName()));
            }
            List<String> dimensions = ((IndexableAdapter)projectionAdapters.get(0)).getDimensionNames(false);
            List<String> metrics = Arrays.stream(projectionSchema.getAggregators()).map(AggregatorFactory::getName).collect(Collectors.toList());
            ArrayList<DimensionMergerV9> mergers = new ArrayList<DimensionMergerV9>();
            LinkedHashMap columnFormats = Maps.newLinkedHashMapWithExpectedSize((int)(dimensions.size() + metrics.size()));
            for (String dimension : dimensions) {
                ColumnFormat dimensionFormat = ((IndexableAdapter)projectionAdapters.get(0)).getFormat(dimension);
                columnFormats.put(dimension, dimensionFormat);
                DimensionHandler handler = dimensionFormat.getColumnHandler(dimension);
                DimensionMergerV9 merger = handler.makeMerger(Projections.getProjectionSmooshFileName(spec.getSchema(), dimension), indexSpec, segmentWriteOutMedium, dimensionFormat.toColumnCapabilities(), progress, segmentBaseDir, closer);
                if (parentMergers.containsKey(dimension)) {
                    merger.attachParent(parentMergers.get(dimension), projectionAdapters);
                } else {
                    merger.writeMergedValueDictionary(projectionAdapters);
                }
                mergers.add(merger);
            }
            for (String metric : metrics) {
                columnFormats.put(metric, ((IndexableAdapter)projectionAdapters.get(0)).getFormat(metric));
            }
            GenericColumnSerializer timeWriter = projectionSchema.getTimeColumnName() != null ? this.setupTimeWriter(segmentWriteOutMedium, indexSpec) : null;
            ArrayList<GenericColumnSerializer> metricWriters = this.setupMetricsWriters(segmentWriteOutMedium, metrics, columnFormats, indexSpec, Projections.getProjectionSmooshPrefix(spec.getSchema()));
            Function<List, TimeAndDimsIterator> rowMergerFn = rowIterators -> new RowCombiningTimeAndDimsIterator((List<TransformableRowIterator>)rowIterators, projectionSchema.getAggregators(), metrics);
            ArrayList perIndexRowIterators = Lists.newArrayListWithCapacity((int)projectionAdapters.size());
            for (int i = 0; i < projectionAdapters.size(); ++i) {
                IndexableAdapter adapter = (IndexableAdapter)projectionAdapters.get(i);
                TransformableRowIterator target = adapter.getRows();
                perIndexRowIterators.add(IndexMerger.toMergedIndexRowIterator(target, i, mergers));
            }
            TimeAndDimsIterator timeAndDimsIterator = rowMergerFn.apply(perIndexRowIterators);
            closer.register(timeAndDimsIterator);
            int rowCount = 0;
            ArrayList<IntBuffer> rowNumConversions = new ArrayList<IntBuffer>(projectionAdapters.size());
            for (IndexableAdapter adapter : projectionAdapters) {
                int[] arr = new int[adapter.getNumRows()];
                Arrays.fill(arr, -1);
                rowNumConversions.add(IntBuffer.wrap(arr));
            }
            String section = "walk through and merge projection[" + projectionSchema.getName() + "] rows";
            progress.startSection(section);
            long time = startTime = System.currentTimeMillis();
            while (timeAndDimsIterator.moveToNext()) {
                progress.progress();
                TimeAndDimsPointer timeAndDims = timeAndDimsIterator.getPointer();
                if (timeWriter != null) {
                    timeWriter.serialize(timeAndDims.timestampSelector);
                }
                for (int metricIndex = 0; metricIndex < timeAndDims.getNumMetrics(); ++metricIndex) {
                    metricWriters.get(metricIndex).serialize(timeAndDims.getMetricSelector(metricIndex));
                }
                for (int dimIndex = 0; dimIndex < timeAndDims.getNumDimensions(); ++dimIndex) {
                    DimensionMergerV9 merger = (DimensionMergerV9)mergers.get(dimIndex);
                    if (merger.hasOnlyNulls()) continue;
                    merger.processMergedRow(timeAndDims.getDimensionSelector(dimIndex));
                }
                RowCombiningTimeAndDimsIterator comprisedRows = (RowCombiningTimeAndDimsIterator)timeAndDimsIterator;
                int originalIteratorIndex = comprisedRows.nextCurrentlyCombinedOriginalIteratorIndex(0);
                while (originalIteratorIndex >= 0) {
                    IntBuffer conversionBuffer = (IntBuffer)rowNumConversions.get(originalIteratorIndex);
                    int minRowNum = comprisedRows.getMinCurrentlyCombinedRowNumByOriginalIteratorIndex(originalIteratorIndex);
                    int maxRowNum = comprisedRows.getMaxCurrentlyCombinedRowNumByOriginalIteratorIndex(originalIteratorIndex);
                    for (int rowNum = minRowNum; rowNum <= maxRowNum; ++rowNum) {
                        while (conversionBuffer.position() < rowNum) {
                            conversionBuffer.put(-1);
                        }
                        conversionBuffer.put(rowCount);
                    }
                    originalIteratorIndex = comprisedRows.nextCurrentlyCombinedOriginalIteratorIndex(originalIteratorIndex + 1);
                }
                if (++rowCount % 500000 != 0) continue;
                log.debug("walked 500,000/%d rows of projection[%s] in %,d millis.", rowCount, projectionSchema.getName(), System.currentTimeMillis() - time);
                time = System.currentTimeMillis();
            }
            for (IntBuffer rowNumConversion : rowNumConversions) {
                rowNumConversion.rewind();
            }
            log.debug("completed walk through of %,d rows of projection[%s] in %,d millis.", rowCount, projectionSchema.getName(), System.currentTimeMillis() - startTime);
            progress.stopSection(section);
            String section2 = "build projection[" + projectionSchema.getName() + "] inverted index and columns";
            progress.startSection(section2);
            if (projectionSchema.getTimeColumnName() != null) {
                this.makeTimeColumn(segmentFileBuilder, progress, timeWriter, indexSpec, Projections.getProjectionSmooshFileName(spec.getSchema(), projectionSchema.getTimeColumnName()));
            }
            this.makeMetricsColumns(segmentFileBuilder, progress, metrics, columnFormats, metricWriters, indexSpec, Projections.getProjectionSmooshPrefix(spec.getSchema()));
            for (int i = 0; i < dimensions.size(); ++i) {
                String dimension = dimensions.get(i);
                DimensionMergerV9 merger = (DimensionMergerV9)mergers.get(i);
                merger.writeIndexes(rowNumConversions);
                ColumnDescriptor columnDesc = merger.hasOnlyNulls() ? ColumnDescriptor.builder().setValueType((ValueType)((ColumnFormat)columnFormats.get(dimension)).getLogicalType().getType()).addSerde(new NullColumnPartSerde(rowCount, indexSpec.getBitmapSerdeFactory())).build() : merger.makeColumnDescriptor();
                this.makeColumn(segmentFileBuilder, Projections.getProjectionSmooshFileName(spec.getSchema(), dimension), columnDesc);
            }
            progress.stopSection(section2);
            projectionMetadata.add(new AggregateProjectionMetadata(projectionSchema, rowCount));
        }
        return segmentMetadata.withProjections(projectionMetadata);
    }

    protected void makeTimeColumn(SegmentFileBuilder segmentFileBuilder, ProgressIndicator progress, GenericColumnSerializer timeWriter, IndexSpec indexSpec, String name) throws IOException {
        String section = "make time column";
        progress.startSection("make time column");
        long startTime = System.currentTimeMillis();
        ColumnDescriptor serdeficator = ColumnDescriptor.builder().setValueType(ValueType.LONG).addSerde(IndexMergerBase.createLongColumnPartSerde(timeWriter, indexSpec)).build();
        this.makeColumn(segmentFileBuilder, name, serdeficator);
        log.debug("Completed time column in %,d millis.", System.currentTimeMillis() - startTime);
        progress.stopSection("make time column");
    }

    protected void makeMetricsColumns(SegmentFileBuilder segmentFileBuilder, ProgressIndicator progress, List<String> mergedMetrics, Map<String, ColumnFormat> metricsTypes, List<GenericColumnSerializer> metWriters, IndexSpec indexSpec, String namePrefix) throws IOException {
        String section = "make metric columns";
        progress.startSection("make metric columns");
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < mergedMetrics.size(); ++i) {
            String metric = mergedMetrics.get(i);
            long metricStartTime = System.currentTimeMillis();
            GenericColumnSerializer writer = metWriters.get(i);
            ColumnDescriptor.Builder builder = ColumnDescriptor.builder();
            ColumnType type = metricsTypes.get(metric).getLogicalType();
            switch ((ValueType)type.getType()) {
                case LONG: {
                    builder.setValueType(ValueType.LONG);
                    builder.addSerde(IndexMergerBase.createLongColumnPartSerde(writer, indexSpec));
                    break;
                }
                case FLOAT: {
                    builder.setValueType(ValueType.FLOAT);
                    builder.addSerde(IndexMergerBase.createFloatColumnPartSerde(writer, indexSpec));
                    break;
                }
                case DOUBLE: {
                    builder.setValueType(ValueType.DOUBLE);
                    builder.addSerde(IndexMergerBase.createDoubleColumnPartSerde(writer, indexSpec));
                    break;
                }
                case COMPLEX: {
                    String typeName = type.getComplexTypeName();
                    builder.setValueType(ValueType.COMPLEX);
                    builder.addSerde(ComplexColumnPartSerde.serializerBuilder().withTypeName(typeName).withDelegate(writer).build());
                    break;
                }
                default: {
                    throw new ISE("Unknown type[%s]", type);
                }
            }
            String columnName = namePrefix + metric;
            this.makeColumn(segmentFileBuilder, columnName, builder.build());
            log.debug("Completed metric column[%s] in %,d millis.", columnName, System.currentTimeMillis() - metricStartTime);
        }
        log.debug("Completed metric columns in %,d millis.", System.currentTimeMillis() - startTime);
        progress.stopSection("make metric columns");
    }

    protected IndexMergeResult mergeIndexesAndWriteColumns(List<IndexableAdapter> adapters, ProgressIndicator progress, TimeAndDimsIterator timeAndDimsIterator, GenericColumnSerializer timeWriter, ArrayList<GenericColumnSerializer> metricWriters, List<DimensionMergerV9> mergers) throws IOException {
        String section = "walk through and merge rows";
        progress.startSection("walk through and merge rows");
        long startTime = System.currentTimeMillis();
        int rowCount = 0;
        ArrayList<IntBuffer> rowNumConversions = new ArrayList<IntBuffer>(adapters.size());
        for (IndexableAdapter adapter : adapters) {
            int[] arr = new int[adapter.getNumRows()];
            Arrays.fill(arr, -1);
            rowNumConversions.add(IntBuffer.wrap(arr));
        }
        long time = System.currentTimeMillis();
        while (timeAndDimsIterator.moveToNext()) {
            progress.progress();
            TimeAndDimsPointer timeAndDims = timeAndDimsIterator.getPointer();
            timeWriter.serialize(timeAndDims.timestampSelector);
            for (int metricIndex = 0; metricIndex < timeAndDims.getNumMetrics(); ++metricIndex) {
                metricWriters.get(metricIndex).serialize(timeAndDims.getMetricSelector(metricIndex));
            }
            for (int dimIndex = 0; dimIndex < timeAndDims.getNumDimensions(); ++dimIndex) {
                DimensionMergerV9 merger = mergers.get(dimIndex);
                if (merger.hasOnlyNulls()) continue;
                merger.processMergedRow(timeAndDims.getDimensionSelector(dimIndex));
            }
            if (timeAndDimsIterator instanceof RowCombiningTimeAndDimsIterator) {
                RowCombiningTimeAndDimsIterator comprisedRows = (RowCombiningTimeAndDimsIterator)timeAndDimsIterator;
                int originalIteratorIndex = comprisedRows.nextCurrentlyCombinedOriginalIteratorIndex(0);
                while (originalIteratorIndex >= 0) {
                    IntBuffer conversionBuffer = (IntBuffer)rowNumConversions.get(originalIteratorIndex);
                    int minRowNum = comprisedRows.getMinCurrentlyCombinedRowNumByOriginalIteratorIndex(originalIteratorIndex);
                    int maxRowNum = comprisedRows.getMaxCurrentlyCombinedRowNumByOriginalIteratorIndex(originalIteratorIndex);
                    for (int rowNum = minRowNum; rowNum <= maxRowNum; ++rowNum) {
                        while (conversionBuffer.position() < rowNum) {
                            conversionBuffer.put(-1);
                        }
                        conversionBuffer.put(rowCount);
                    }
                    originalIteratorIndex = comprisedRows.nextCurrentlyCombinedOriginalIteratorIndex(originalIteratorIndex + 1);
                }
            } else if (timeAndDimsIterator instanceof MergingRowIterator) {
                RowPointer rowPointer = (RowPointer)timeAndDims;
                IntBuffer conversionBuffer = (IntBuffer)rowNumConversions.get(rowPointer.getIndexNum());
                int rowNum = rowPointer.getRowNum();
                while (conversionBuffer.position() < rowNum) {
                    conversionBuffer.put(-1);
                }
                conversionBuffer.put(rowCount);
            } else {
                throw new IllegalStateException("Filling row num conversions is supported only with RowCombining and Merging iterators");
            }
            if (++rowCount % 500000 != 0) continue;
            log.debug("walked 500,000/%d rows in %,d millis.", rowCount, System.currentTimeMillis() - time);
            time = System.currentTimeMillis();
        }
        for (IntBuffer rowNumConversion : rowNumConversions) {
            rowNumConversion.rewind();
        }
        log.debug("completed walk through of %,d rows in %,d millis.", rowCount, System.currentTimeMillis() - startTime);
        progress.stopSection("walk through and merge rows");
        return new IndexMergeResult(rowNumConversions, rowCount);
    }

    protected GenericColumnSerializer setupTimeWriter(SegmentWriteOutMedium segmentWriteOutMedium, IndexSpec indexSpec) throws IOException {
        GenericColumnSerializer timeWriter = IndexMergerBase.createLongColumnSerializer(segmentWriteOutMedium, "little_end_time", indexSpec);
        timeWriter.open();
        return timeWriter;
    }

    protected ArrayList<GenericColumnSerializer> setupMetricsWriters(SegmentWriteOutMedium segmentWriteOutMedium, List<String> mergedMetrics, Map<String, ColumnFormat> metricsTypes, IndexSpec indexSpec, String prefix) throws IOException {
        ArrayList metWriters = Lists.newArrayListWithCapacity((int)mergedMetrics.size());
        for (String metric : mergedMetrics) {
            GenericColumnSerializer writer;
            ColumnType type = metricsTypes.get(metric).getLogicalType();
            String outputName = prefix + metric;
            switch ((ValueType)type.getType()) {
                case LONG: {
                    writer = IndexMergerBase.createLongColumnSerializer(segmentWriteOutMedium, outputName, indexSpec);
                    break;
                }
                case FLOAT: {
                    writer = IndexMergerBase.createFloatColumnSerializer(segmentWriteOutMedium, outputName, indexSpec);
                    break;
                }
                case DOUBLE: {
                    writer = IndexMergerBase.createDoubleColumnSerializer(segmentWriteOutMedium, outputName, indexSpec);
                    break;
                }
                case COMPLEX: {
                    ComplexMetricSerde serde = ComplexMetrics.getSerdeForType(type.getComplexTypeName());
                    if (serde == null) {
                        throw new ISE("Unknown type[%s]", type.getComplexTypeName());
                    }
                    writer = serde.getSerializer(segmentWriteOutMedium, outputName, indexSpec);
                    break;
                }
                default: {
                    throw new ISE("Unknown type[%s]", type);
                }
            }
            writer.open();
            metWriters.add(writer);
        }
        return metWriters;
    }

    protected void writeDimValuesAndSetupDimConversion(List<IndexableAdapter> indexes, ProgressIndicator progress, List<String> mergedDimensions, List<DimensionMergerV9> mergers) throws IOException {
        String section = "setup dimension conversions";
        progress.startSection("setup dimension conversions");
        for (int dimIndex = 0; dimIndex < mergedDimensions.size(); ++dimIndex) {
            mergers.get(dimIndex).writeMergedValueDictionary(indexes);
        }
        progress.stopSection("setup dimension conversions");
    }

    protected void mergeFormat(List<IndexableAdapter> adapters, List<String> mergedDimensions, Map<String, ColumnFormat> metricTypes, List<ColumnFormat> dimFormats) {
        HashMap<String, ColumnFormat> columnFormats = new HashMap<String, ColumnFormat>();
        for (IndexableAdapter adapter : adapters) {
            ColumnFormat format;
            for (String dimension : adapter.getDimensionNames(false)) {
                format = adapter.getFormat(dimension);
                columnFormats.compute(dimension, (d, existingFormat) -> existingFormat == null ? format : format.merge((ColumnFormat)existingFormat));
            }
            for (String metric : adapter.getMetricNames()) {
                format = adapter.getFormat(metric);
                ColumnFormat merged = columnFormats.compute(metric, (m, existingFormat) -> existingFormat == null ? format : format.merge((ColumnFormat)existingFormat));
                metricTypes.put(metric, merged);
            }
        }
        for (String dim : mergedDimensions) {
            dimFormats.add((ColumnFormat)columnFormats.get(dim));
        }
    }

    protected Map<String, DimensionHandler> makeDimensionHandlers(List<String> mergedDimensions, List<ColumnFormat> dimFormats) {
        LinkedHashMap<String, DimensionHandler> handlers = new LinkedHashMap<String, DimensionHandler>();
        for (int i = 0; i < mergedDimensions.size(); ++i) {
            String dimName = mergedDimensions.get(i);
            DimensionHandler handler = dimFormats.get(i).getColumnHandler(dimName);
            handlers.put(dimName, handler);
        }
        return handlers;
    }

    protected TimeAndDimsIterator makeMergedTimeAndDimsIterator(List<IndexableAdapter> indexes, List<String> mergedDimensionsWithTime, List<String> mergedMetrics, Function<List<TransformableRowIterator>, TimeAndDimsIterator> rowMergerFn, Map<String, DimensionHandler> handlers, List<DimensionMergerV9> mergers) {
        ArrayList perIndexRowIterators = Lists.newArrayListWithCapacity((int)indexes.size());
        for (int i = 0; i < indexes.size(); ++i) {
            IndexableAdapter adapter = indexes.get(i);
            TransformableRowIterator target = adapter.getRows();
            if (!mergedDimensionsWithTime.equals(adapter.getDimensionNames(true)) || !mergedMetrics.equals(adapter.getMetricNames())) {
                target = this.makeRowIteratorWithReorderedColumns(mergedDimensionsWithTime, mergedMetrics, handlers, adapter, target);
            }
            perIndexRowIterators.add(IndexMerger.toMergedIndexRowIterator(target, i, mergers));
        }
        return rowMergerFn.apply(perIndexRowIterators);
    }

    private TransformableRowIterator makeRowIteratorWithReorderedColumns(List<String> reorderedDimensionsWithTime, List<String> reorderedMetrics, Map<String, DimensionHandler> originalHandlers, IndexableAdapter originalAdapter, TransformableRowIterator originalIterator) {
        final RowPointer reorderedRowPointer = IndexMergerBase.reorderRowPointerColumns(reorderedDimensionsWithTime, reorderedMetrics, originalHandlers, originalAdapter, originalIterator.getPointer());
        final TimeAndDimsPointer reorderedMarkedRowPointer = IndexMergerBase.reorderRowPointerColumns(reorderedDimensionsWithTime, reorderedMetrics, originalHandlers, originalAdapter, originalIterator.getMarkedPointer());
        return new ForwardingRowIterator(originalIterator){

            @Override
            public RowPointer getPointer() {
                return reorderedRowPointer;
            }

            @Override
            public TimeAndDimsPointer getMarkedPointer() {
                return reorderedMarkedRowPointer;
            }
        };
    }

    private static <T extends TimeAndDimsPointer> T reorderRowPointerColumns(List<String> reorderedDimensionsWithTime, List<String> reorderedMetrics, Map<String, DimensionHandler> originalHandlers, IndexableAdapter originalAdapter, T originalRowPointer) {
        int reorderedTimePosition = reorderedDimensionsWithTime.indexOf("__time");
        if (reorderedTimePosition < 0) {
            throw DruidException.defensive("Missing column[%s]", "__time");
        }
        ColumnValueSelector[] reorderedDimensionSelectors = (ColumnValueSelector[])reorderedDimensionsWithTime.stream().filter(column -> !"__time".equals(column)).map(dimName -> {
            int dimIndex = originalAdapter.getDimensionNames(false).indexOf(dimName);
            if (dimIndex >= 0) {
                return originalRowPointer.getDimensionSelector(dimIndex);
            }
            return NilColumnValueSelector.instance();
        }).toArray(ColumnValueSelector[]::new);
        List<DimensionHandler> reorderedHandlers = reorderedDimensionsWithTime.stream().filter(column -> !"__time".equals(column)).map(originalHandlers::get).collect(Collectors.toList());
        ColumnValueSelector[] reorderedMetricSelectors = (ColumnValueSelector[])reorderedMetrics.stream().map(metricName -> {
            int metricIndex = originalAdapter.getMetricNames().indexOf(metricName);
            if (metricIndex >= 0) {
                return originalRowPointer.getMetricSelector(metricIndex);
            }
            return NilColumnValueSelector.instance();
        }).toArray(ColumnValueSelector[]::new);
        if (originalRowPointer instanceof RowPointer) {
            return (T)new RowPointer(originalRowPointer.timestampSelector, reorderedTimePosition, reorderedDimensionSelectors, reorderedHandlers, reorderedMetricSelectors, reorderedMetrics, ((RowPointer)originalRowPointer).rowNumPointer);
        }
        return (T)new TimeAndDimsPointer(originalRowPointer.timestampSelector, reorderedTimePosition, reorderedDimensionSelectors, reorderedHandlers, reorderedMetricSelectors, reorderedMetrics);
    }

    static ColumnPartSerde createLongColumnPartSerde(GenericColumnSerializer serializer, IndexSpec indexSpec) {
        return LongNumericColumnPartSerdeV2.serializerBuilder().withByteOrder(IndexIO.BYTE_ORDER).withBitmapSerdeFactory(indexSpec.getBitmapSerdeFactory()).withDelegate(serializer).build();
    }

    static ColumnPartSerde createDoubleColumnPartSerde(GenericColumnSerializer serializer, IndexSpec indexSpec) {
        return DoubleNumericColumnPartSerdeV2.serializerBuilder().withByteOrder(IndexIO.BYTE_ORDER).withBitmapSerdeFactory(indexSpec.getBitmapSerdeFactory()).withDelegate(serializer).build();
    }

    static ColumnPartSerde createFloatColumnPartSerde(GenericColumnSerializer serializer, IndexSpec indexSpec) {
        return FloatNumericColumnPartSerdeV2.serializerBuilder().withByteOrder(IndexIO.BYTE_ORDER).withBitmapSerdeFactory(indexSpec.getBitmapSerdeFactory()).withDelegate(serializer).build();
    }

    static GenericColumnSerializer createLongColumnSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String columnName, IndexSpec indexSpec) {
        return LongColumnSerializerV2.create(columnName, segmentWriteOutMedium, columnName, indexSpec.getMetricCompression(), indexSpec.getLongEncoding(), indexSpec.getBitmapSerdeFactory());
    }

    static GenericColumnSerializer createDoubleColumnSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String columnName, IndexSpec indexSpec) {
        return DoubleColumnSerializerV2.create(columnName, segmentWriteOutMedium, columnName, indexSpec.getMetricCompression(), indexSpec.getBitmapSerdeFactory());
    }

    static GenericColumnSerializer createFloatColumnSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String columnName, IndexSpec indexSpec) {
        return FloatColumnSerializerV2.create(columnName, segmentWriteOutMedium, columnName, indexSpec.getMetricCompression(), indexSpec.getBitmapSerdeFactory());
    }

    protected static class DimensionsSpecInspector {
        private final boolean storeEmptyColumns;
        private final Set<String> explicitDimensions;
        private final boolean includeAllDimensions;

        private DimensionsSpecInspector(boolean storeEmptyColumns, @Nullable DimensionsSpec dimensionsSpec) {
            this.storeEmptyColumns = storeEmptyColumns;
            this.explicitDimensions = dimensionsSpec == null ? ImmutableSet.of() : new HashSet<String>(dimensionsSpec.getDimensionNames());
            this.includeAllDimensions = dimensionsSpec != null && (dimensionsSpec.isIncludeAllDimensions() || dimensionsSpec.useSchemaDiscovery());
        }

        protected boolean shouldStore(String dimension) {
            return this.storeEmptyColumns && (this.includeAllDimensions || this.explicitDimensions.contains(dimension));
        }
    }

    protected static class IndexMergeResult {
        @Nullable
        protected final List<IntBuffer> rowNumConversions;
        protected final int rowCount;

        private IndexMergeResult(@Nullable List<IntBuffer> rowNumConversions, int rowCount) {
            this.rowNumConversions = rowNumConversions;
            this.rowCount = rowCount;
        }
    }
}

