/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.ObjectAVLTreeSet;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.query.OrderBy;
import org.apache.druid.segment.AggregateProjectionMetadata;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.Cursors;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.column.BaseColumnHolder;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.ListIndexed;
import org.apache.druid.segment.file.SegmentFileMapper;
import org.apache.druid.segment.projections.Projections;
import org.apache.druid.segment.projections.QueryableProjection;
import org.joda.time.Interval;

public abstract class SimpleQueryableIndex
implements QueryableIndex {
    public static final Interner<List<OrderBy>> ORDERING_INTERNER = Interners.newWeakInterner();
    private final Interval dataInterval;
    private final List<String> columnNames;
    private final Indexed<String> availableDimensions;
    private final BitmapFactory bitmapFactory;
    private final Map<String, Supplier<BaseColumnHolder>> columns;
    private final List<OrderBy> ordering;
    private final Map<String, AggregateProjectionMetadata> projectionsMap;
    private final SortedSet<AggregateProjectionMetadata> projections;
    private final Map<String, Map<String, Supplier<BaseColumnHolder>>> projectionColumns;
    private final SegmentFileMapper fileMapper;
    private final Supplier<Map<String, DimensionHandler>> dimensionHandlers;

    public SimpleQueryableIndex(Interval dataInterval, Indexed<String> dimNames, BitmapFactory bitmapFactory, Map<String, Supplier<BaseColumnHolder>> columns, SegmentFileMapper fileMapper) {
        this(dataInterval, dimNames, bitmapFactory, columns, fileMapper, null, null);
    }

    public SimpleQueryableIndex(Interval dataInterval, Indexed<String> dimNames, BitmapFactory bitmapFactory, Map<String, Supplier<BaseColumnHolder>> columns, SegmentFileMapper fileMapper, @Nullable Metadata metadata, @Nullable Map<String, Map<String, Supplier<BaseColumnHolder>>> projectionColumns) {
        Preconditions.checkNotNull(columns.get("__time"));
        this.dataInterval = (Interval)Preconditions.checkNotNull((Object)dataInterval, (Object)"dataInterval");
        ImmutableList.Builder columnNamesBuilder = ImmutableList.builder();
        LinkedHashSet<String> dimsFirst = new LinkedHashSet<String>();
        for (String dimName : dimNames) {
            dimsFirst.add(dimName);
        }
        for (String columnName : columns.keySet()) {
            if ("__time".equals(columnName)) continue;
            dimsFirst.add(columnName);
        }
        columnNamesBuilder.addAll(dimsFirst);
        this.columnNames = columnNamesBuilder.build();
        this.availableDimensions = dimNames;
        this.bitmapFactory = bitmapFactory;
        this.columns = columns;
        this.fileMapper = fileMapper;
        this.projectionColumns = projectionColumns == null ? Collections.emptyMap() : projectionColumns;
        this.dimensionHandlers = Suppliers.memoize(() -> this.initDimensionHandlers(this.availableDimensions));
        if (metadata != null) {
            this.ordering = metadata.getOrdering() != null ? (List<Object>)ORDERING_INTERNER.intern(metadata.getOrdering()) : Cursors.ascendingTimeOrder();
            if (metadata.getProjections() != null) {
                this.projectionsMap = Maps.newHashMapWithExpectedSize((int)metadata.getProjections().size());
                this.projections = new ObjectAVLTreeSet(AggregateProjectionMetadata.COMPARATOR);
                for (AggregateProjectionMetadata projection : metadata.getProjections()) {
                    this.projections.add(projection);
                    this.projectionsMap.put(projection.getSchema().getName(), projection);
                }
            } else {
                this.projectionsMap = Collections.emptyMap();
                this.projections = Collections.emptySortedSet();
            }
        } else {
            this.ordering = Cursors.ascendingTimeOrder();
            this.projections = Collections.emptySortedSet();
            this.projectionsMap = Collections.emptyMap();
        }
    }

    @Override
    public Interval getDataInterval() {
        return this.dataInterval;
    }

    @Override
    public int getNumRows() {
        return ((BaseColumnHolder)this.columns.get("__time").get()).getLength();
    }

    @Override
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public Indexed<String> getAvailableDimensions() {
        return this.availableDimensions;
    }

    @Override
    public List<OrderBy> getOrdering() {
        return this.ordering;
    }

    @Override
    public BitmapFactory getBitmapFactoryForDimensions() {
        return this.bitmapFactory;
    }

    @Override
    @Nullable
    public BaseColumnHolder getColumnHolder(String columnName) {
        Supplier<BaseColumnHolder> columnHolderSupplier = this.columns.get(columnName);
        return columnHolderSupplier == null ? null : (BaseColumnHolder)columnHolderSupplier.get();
    }

    @VisibleForTesting
    public Map<String, Supplier<BaseColumnHolder>> getColumns() {
        return this.columns;
    }

    @VisibleForTesting
    public SegmentFileMapper getFileMapper() {
        return this.fileMapper;
    }

    @Override
    public void close() {
        if (this.fileMapper != null) {
            this.fileMapper.close();
        }
    }

    @Override
    public abstract Metadata getMetadata();

    @Override
    public Map<String, DimensionHandler> getDimensionHandlers() {
        return (Map)this.dimensionHandlers.get();
    }

    private Map<String, DimensionHandler> initDimensionHandlers(Indexed<String> availableDimensions) {
        LinkedHashMap dimensionHandlerMap = Maps.newLinkedHashMap();
        for (String dim : availableDimensions) {
            BaseColumnHolder columnHolder = this.getColumnHolder(dim);
            DimensionHandler handler = columnHolder.getColumnFormat().getColumnHandler(dim);
            dimensionHandlerMap.put(dim, handler);
        }
        return dimensionHandlerMap;
    }

    @Override
    @Nullable
    public QueryableProjection<QueryableIndex> getProjection(CursorBuildSpec cursorBuildSpec) {
        return Projections.findMatchingProjection(cursorBuildSpec, this.projections, this.dataInterval, (projectionName, columnName) -> this.projectionColumns.get(projectionName).containsKey(columnName) || this.getColumnCapabilities(columnName) == null, this::getProjectionQueryableIndex);
    }

    @Override
    public QueryableIndex getProjectionQueryableIndex(String name) {
        final AggregateProjectionMetadata projectionSpec = this.projectionsMap.get(name);
        final Metadata projectionMetadata = new Metadata(null, projectionSpec.getSchema().getAggregators(), null, null, true, projectionSpec.getSchema().getOrderingWithTimeColumnSubstitution(), null);
        return new SimpleQueryableIndex(this.dataInterval, new ListIndexed(projectionSpec.getSchema().getGroupingColumns().stream().filter(x -> !x.equals(projectionSpec.getSchema().getTimeColumnName())).collect(Collectors.toList())), this.bitmapFactory, this.projectionColumns.get(name), this.fileMapper, projectionMetadata, null){

            @Override
            public Metadata getMetadata() {
                return projectionMetadata;
            }

            @Override
            public int getNumRows() {
                return projectionSpec.getNumRows();
            }

            @Override
            public List<OrderBy> getOrdering() {
                return projectionSpec.getSchema().getOrderingWithTimeColumnSubstitution();
            }
        };
    }
}

